/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.api.graphic;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElementFactory;

public interface IDiagramElementGraphicFactory extends IUIElementFactory{


	IDiagramElementView getElement(Class<? extends IDiagramElementView> elementType);
	
	/**
	 * Create a {@link IDiagramElementView} given a {@link IDiagramElement} instance.
	 * This {@link IDiagramElement} instance has to be used to bind {@link IEditorModel}
	 * and  {@link IDiagramElement} of {@link IDiagramElementView} to be created
	 * @param modelElementType
	 * @param modelElementInstance
	 * @return
	 */
	IDiagramElementView getElementByDiagramElementModel(IDiagramElement diagramElement);
	
}
