/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.MethodObserver;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ObservableManager;

public class DiagramElementViewStateHandler {
	
	private DiagramController controller;
	
	public DiagramElementViewStateHandler(DiagramController controller){
		
		this.controller = controller;
		
	}
	
	/**
	 * Listen to diagram element graphic. When its editor model changes
	 * it fires every state that condition is true. 
	 * @param elementGraphic
	 */
	@SuppressWarnings("unchecked")
	public void listen(final IDiagramElementView elementGraphic){
		
		//bind for the initial state
		for(IDiagramElementGraphicState gs:elementGraphic.getStates()){
			
			if (gs.condition(elementGraphic.getDiagramElement(), elementGraphic.getEditorModel())){
				gs.changeGraphicState(elementGraphic);
			}
			
			
		}		
		
		
		ObservableManager.getInstance().addMethodObserver(elementGraphic.getEditorModel(), new MethodObserver<IEditorModel>() {
		
		@Override
		public void afterMethodCalled(IEditorModel model,
				Object... parameters) {
				
			
			
			for(IDiagramElementGraphicState gs:elementGraphic.getStates()){
				
				if (gs.condition(elementGraphic.getDiagramElement(), elementGraphic.getEditorModel())){
					gs.changeGraphicState(elementGraphic);
				}
				
				
			}
			
			
			
		}
		@Override
			public void beforeMethodCalled(IEditorModel model,
					Object... parameters) {
				
				
			}
		
		
		});
		
		
		
	}
	
	
	
	
}
