/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationWarningEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.google.gwt.event.shared.GwtEvent;

public class ValidationWarningEvent extends GwtEvent<IValidationHandler> implements IValidationWarningEvent{
	
	public static Type<IValidationHandler> TYPE = new Type<IValidationHandler>();
	
	private HashSet<IConformityRule> rulesInWarning;
	
	public ValidationWarningEvent(HashSet<IConformityRule> rulesInWarning) {
		
		this.rulesInWarning = rulesInWarning;
		
	}
	
	@Override
	protected void dispatch(IValidationHandler handler) {
		handler.onValidationWarning(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IValidationHandler> getAssociatedType() {
		return TYPE;
	}

	

	@Override
	public HashSet<IConformityRule> getRulesInWarning() {
		return rulesInWarning;
	}



}
