/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.validation;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;

public abstract class AbstractDiagramElementViewConformityRule implements IDiagramElementViewConformityRule{
	
	private IDiagramElementView diagramElementView; 
	
	public AbstractDiagramElementViewConformityRule(IDiagramElementView diagramElementView) {
		this.diagramElementView = diagramElementView;
	}
	
	
	@Override
	public IDiagramElementView getNonConformElement() {
		return diagramElementView;
	}


	
	@Override
	public boolean equals(Object obj) {
		
		AbstractDiagramElementViewConformityRule rule = (AbstractDiagramElementViewConformityRule) obj;
		
		if (rule.getNonConformElement().equals(this.getNonConformElement()) && rule.getRuleName().equals(this.getRuleName())){
			return true;
		}
		
		return false;
	}
	
	@Override
	public int hashCode() {
		return this.getNonConformElement().hashCode()+this.getRuleName().hashCode();
	}
	
}
