/**
 * model-extension - Model extension - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client;

import java.io.Serializable;

public class AttributeExtension implements Serializable{

	private String attributeQNameNS;
	private String attributeQNameLocalPart;
	private String attributeValue;
	
	protected AttributeExtension(){}

	public AttributeExtension(String attributeQNameNS,
			String attributeQNameLocalPart, String attributeValue) {
		this.attributeQNameNS = attributeQNameNS;
		this.attributeQNameLocalPart = attributeQNameLocalPart;
		this.attributeValue = attributeValue;
	}

	public String getAttributeQNameNS() {
		return attributeQNameNS;
	}

	public void setAttributeQNameNS(String attributeQNameNS) {
		this.attributeQNameNS = attributeQNameNS;
	}

	public String getAttributeQNameLocalPart() {
		return attributeQNameLocalPart;
	}

	public void setAttributeQNameLocalPart(String attributeQNameLocalPart) {
		this.attributeQNameLocalPart = attributeQNameLocalPart;
	}

	public String getAttributeValue() {
		return attributeValue;
	}

	public void setAttributeValue(String attributeValue) {
		this.attributeValue = attributeValue;
	}
	
	public boolean hasSameErasure(AttributeExtension other){
		return attributeQNameLocalPart.equals(((AttributeExtension) other).attributeQNameLocalPart)
			&& attributeQNameNS.equals(((AttributeExtension) other).attributeQNameNS);
	}
	
	@Override
	public boolean equals(Object other){
		if(other instanceof AttributeExtension){
			return hasSameErasure((AttributeExtension)other)
				&& attributeValue.equals(((AttributeExtension) other).attributeValue);
		}
		return false;
	}
}
