/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IContainer;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGDocument;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

public class SVGElement extends Widget implements ISVGElement{
	
	protected String id;
	protected float x;
	protected float y;
	private float height;
	private float width;
	
	private IContainer container;
	
	private boolean visible;
	private float fillOpacity;
	private String strokeColour;
	private String fillColour;
	private String strokeDashArray;
	
	private ISVGDocument canvas;
	

	protected ISVGElement impl;

	
	public SVGElement(Element element) {
		this.x 	= 0;
		this.y 	= 0;

		setElement(element);

		
	}
	

	

	public void setImpl(ISVGElement impl) {
		this.impl = impl;
	}
	
	public ISVGElement getImpl() {
		return impl;
	}
	
	public SVGElement(Element element,float x,float y) {
		this(element);
		this.x 	= x;
		this.y 	= y;
		
		
	}
	

	@Override
	public int getAbsoluteLeft() {
		return (int) (this.getContainer().getAbsoluteLeft() + this.getX());
	}
	
	public int getAbsoluteTop(){
		return (int) (this.getContainer().getAbsoluteTop() + this.getY());
	}
	
	
	@Override
	public float getX() {
		return x;
	}

	@Override
	public float getY() {
		return y;
	}

	@Override
	public ISVGDocument getCanvas() {
		return canvas;
	}

	@Override
	public float getHeight() {
		return height;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public float getWidth() {
		return width;
	}

	@Override
	public boolean isVisible() {
		return visible;
	}





	@Override
	public void setCanvas(ISVGDocument canvas) {
		this.canvas = canvas;		
	}

	@Override
	public void setVisible(boolean visible) {
		this.impl.setVisible(visible);
		this.visible = visible;
	}


	@Override
	public void translate(float dx, float dy) {
		this.impl.translate(dx, dy);
		this.x 	= x + dx;
		this.y  = y + dy;
	}


	

//	public boolean equals(Object obj) {
//		
//		ISVGElement compareMe = (ISVGElement) obj;
//		
//		if (compareMe.getId().equals(this.getId())){
//			return true;
//		}
//		
//		return false;
//	}
//	
//
//	public int hashCode() {
//		return id.hashCode();
//	}

	@Override
	public float getFillOpacity() {
		return fillOpacity;
	}

	@Override
	public String getStrokeColour() {
		return strokeColour;
	}

	@Override
	public void setFillOpacity(float fillOpacity) {
		this.impl.setFillOpacity(fillOpacity);
		this.fillOpacity = fillOpacity;
	}

	@Override
	public void setStokeColour(String colour) {
		this.impl.setStokeColour(colour);
		this.strokeColour = colour;
	}

	@Override
	public String getFillColour() {
		return fillColour;
	}

	@Override
	public String getStrokeDashArray() {
		return strokeDashArray;
	}

	@Override
	public void setFillColour(String colour) {
		this.impl.setFillColour(colour);
		this.fillColour = colour;
	}

	@Override
	public void setStrokeDashArray(String strokeDash) {
		this.impl.setStrokeDashArray(strokeDash);
		this.strokeDashArray = strokeDash;
	}



	@Override
	public void rotate(float degree, boolean isAbsolute) {
		this.impl.rotate(degree, isAbsolute);
		
	}

	@Override
	public void rotate(float degree, int cx, int cy) {
		this.impl.rotate(degree, cx, cy);
	}



	@Override
	public void scale(float xTimes, float yTimes) {
		this.impl.scale(xTimes, yTimes);
	}



	@Override
	public void scale(float xTimes, float yTimes, float centerX, float centerY) {
		this.impl.scale(xTimes, yTimes, centerX, centerY);
	}



	@Override
	public void setId(String id) {
		this.getElement().setAttribute("id", id);
		this.id = id;
	}



	@Override
	public void setX(float x) {
		this.x = x;
	}



	@Override
	public void setY(float y) {
		this.y = y;
	}



	@Override
	public void toBack() {
		this.impl.toBack();
	}



	@Override
	public void toFront() {
		this.impl.toFront();
	}



	@Override
	public void remove() {
		this.impl.remove();
	}




	@Override
	public void setHeight(float height) {
		this.impl.setHeight(height);
		this.height = height;
	}




	@Override
	public void setWidth(float width) {
		this.impl.setWidth(width);
		this.width  = width;
	}


	@Override
	public IContainer getContainer() {
		return container;
	}




	@Override
	public void setContainer(IContainer container) {
		this.container = container;
	}






	
	
	

}
