/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IGroup;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;

public class GroupJSNI extends SVGElementJSNI implements IGroup{


	
	
	protected native Element createGroupJS(JavaScriptObject raphaelPaper)/*-{
	
		var group = raphaelPaper.group();
		
		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.GroupJSNI::setSvgElementJsObject(Lcom/google/gwt/core/client/JavaScriptObject;)(group);
		
		return group.node;
	
	}-*/;

	
	/**
	 * Getters
	 */
	@Override
	public HashSet<ISVGElement> getChildren() {return null;}

	@Override
	public ISVGElement getElementById(String id) {return null;}

	
	@Override
	public void appendChild(ISVGElement svgElement) {
		
		SVGElement svgEl = (SVGElement) svgElement;
		
		this.appendChildJS(this.getSvgElementJsObject(),((SVGElementJSNI)svgEl.getImpl()).getSvgElementJsObject());
		
	}
	
	/**
	 * Setters
	 */
	@Override
	public void removeChild(ISVGElement svgElement) {
		
		SVGElement svgEl = (SVGElement) svgElement;
		
		this.removeChildJS(getSvgElementJsObject(), ((SVGElementJSNI)svgEl.getImpl()).getSvgElementJsObject());
		
	}
	

	@Override
	public void setPointerEvents(String pointerEvents) {
		
		this.setPointerEvetnsJS(getSvgElementJsObject(),pointerEvents);
		
	}


	/**
	 * JSNI IMPL
	 */
	private native void setPointerEvetnsJS(JavaScriptObject jsObj,
			String pointerEvents)/*-{
			
			jsObj.pointerEvents(pointerEvents);
			
	}-*/;
	
	
	
	public native void appendChildJS(JavaScriptObject jsObj,JavaScriptObject  child)/*-{
		
		jsObj.append(child);
	
	}-*/;
	
	public native void removeChildJS(JavaScriptObject jsObj,JavaScriptObject  child)/*-{
		
		jsObj.remove(child);
		
	}-*/;


	@Override
	public int getAbsoluteLeft() {
		// TODO Auto-generated method stub
		return 0;
	}


	@Override
	public int getAbsoluteTop() {
		// TODO Auto-generated method stub
		return 0;
	}

}
