/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.draggable.events;

public interface IDragHandler {

	void onStart(IDragStartEvent event);

	void onMove(IDragMoveEvent event);
	
	void onStop(IDragStopEvent event);
	
	/**
	 * Fired before drop and when current element is part of
	 * acceptable elements of the concerned IDroppable
	 */
	void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event);
	
	/**
	 * Fired before drop and when current element is not part of
	 * acceptable elements of the concerned IDroppable 
	 */
	void onRefusedBeforeDrop(IRefusedBeforeDropEvent event);
	
	/**
	 * Fired after drop and when current element is part of
	 * acceptable elements of the concerned IDroppable
	 */
	void onAcceptedAfterDrop(IAcceptedAfterDropEvent event);
	
	/**
	 * Fired after drop and when current element is not part of
	 * acceptable elements of the concerned IDroppable 
	 */
	void onRefusedAfterDrop(IRefusedAfterDropEvent event);

}
