/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.uipanel;

import java.util.HashMap;
import java.util.LinkedHashMap;

import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDDManager;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.event.dom.client.HasKeyPressHandlers;
import com.google.gwt.event.dom.client.HasScrollHandlers;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.IsWidget;

@SuppressWarnings("unchecked")
public interface IUIPanel extends IsWidget,IDroppableElement,IContainer,HasKeyPressHandlers,HasScrollHandlers, HasAllMouseHandlers,HasClickHandlers,HasHandlers,HasDoubleClickHandlers,IGraph{
	
	String getName();
	
	HashMap<String,ISelectable> getSelectedElements();
	
	void setSelectedElements(HashMap<String,ISelectable> selectedElements);

	IUIElement getUIElementById(String id);
	/**
	 * Returns all UIElement actually in UIPanel
	 */
	LinkedHashMap<String,IUIElement> getUIElements();
	
	void addUIElement(IUIElement uiElement);
	
	void removeElement(IUIElement uiElement);
	
	void removeSelectedElements();
	
	void removeAllElements();
	
	void unSelectAllEments();
	
	IMouseState getMouseState();
	
	float getAbsoluteX();
	
	float getAbsoluteY();
	
	IUIPanelDefaultHandlers getDefaultHandlers();
	
	IDDManager getDDManager();
	
	void setSelectionMarker(ISelectionMarker selectionMarker,int x,int y);
	
	ISelectionMarker getSelectionMarker();
	
	void setSelector(ISelector selector,int x, int y);
	
	ISelector getSelector();
	
	void addUIPanelHandler(IUIPanelHandler panelHandler);
	
	void removeUIPanelHandler(IUIPanelHandler panelHandler);
	
	void removeSelector();
	
	void removeSelectionMarker();
	
	int getWidth();
	
	int getHeight();
}
