/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core.events;

import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.ISizeChangeEvent;
import com.google.gwt.event.shared.GwtEvent;

public class SizeChangeEvent extends GwtEvent<IBoundsUpdateHandler> implements ISizeChangeEvent{
	
	private float oldWidth;
	private float oldHeight;
	private float newWidth;
	private float newHeight;
	
	public static Type<IBoundsUpdateHandler> TYPE = new Type<IBoundsUpdateHandler>();
	
	public SizeChangeEvent(float oldWidth,float oldHeight,float newWidth,float newHeight) {
		
		this.oldWidth = oldWidth;
		this.oldHeight = oldHeight;
		this.newWidth = newWidth;
		this.newHeight =newHeight;
		
	}
	
	
	@Override
	protected void dispatch(IBoundsUpdateHandler handler) {
		handler.onSizeChange(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IBoundsUpdateHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public float getNewHeight() {
		return newHeight;
	}

	@Override
	public float getNewWidth() {
		return newWidth;
	}

	@Override
	public float getOldHeight() {
		return oldHeight;
	}

	@Override
	public float getOldWidth() {
		return oldWidth;
	}

}
