/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDropProxyIndicator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;

public class DropProxyIndicator extends Composite implements IDropProxyIndicator{
	
	private AbsolutePanel panel;
	private IDragProxy dragProxy;
	
	private Image indicator;
	
	public DropProxyIndicator(IDragProxy dragProxy) {
		
		this.dragProxy 	= dragProxy;
		this.panel		= new AbsolutePanel();
		
		this.indicator	= new Image();
		
		this.panel.add(indicator);
		
		initWidget(panel);
		
		this.dropKO();
		
	}
	
	
	@Override
	public void dropKO() {
		this.indicator.setUrl(GWT.getModuleBaseURL()+"/images/icons/cross.png");
	}

	@Override
	public void dropOK() {
		this.indicator.setUrl(GWT.getModuleBaseURL()+"images/icons/accept.png");
	}
	
	@Override
	public IDragProxy getDragProxy() {
		return dragProxy;
	}


	@Override
	public void setAbsoluteTop(int top) {
		RootPanel.get().setWidgetPosition(this.panel, panel.getAbsoluteLeft(), top);
	}


	@Override
	public void setAbsoluteLeft(int left) {
		RootPanel.get().setWidgetPosition(this.panel, left, panel.getAbsoluteTop());
	}

}
