/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.droppable;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;

/**
 * 
 * Drag and drop manager. Handles everything that can be dragged 
 * for eventually being dropped.
 * 
 * Its main role is to notify droppable when a draggable element is over/out/dropped 
 * 
 * @author nfleury
 *
 */
public interface IDDManager {
	
	IUIPanel getUIPanel();
	
	void draggingElement(IDraggableElement draggedElement,float x,float y);

	void releasingDragElement(IDraggableElement draggedStoppedElement,float x,float y);

	void dragStartElement(IDraggableElement draggedStartElement);
	
	void addDroppable(IDroppableElement droppable);
	
	ArrayList<IDroppableElement> getDroppables();

	void removeDroppable(IDroppableElement droppable);
}
