/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable;


import java.util.HashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.AddWayPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Region;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.user.client.Window;

public class ConnectorDefaultHandlers implements IConnectorDefaultHandlers {

	private IConnector connector;

	private int mouseX;
	private int mouseY;

	public ConnectorDefaultHandlers(IConnector connector) {

		this.connector = connector;

	}

	@Override
	public void attachDefaultHandlers() {

		this.connector.addMouseMoveHandler(new MouseMoveHandler() {

			@Override
			public void onMouseMove(MouseMoveEvent event) {

				mouseX = event.getClientX();
				mouseY = event.getClientY();

			}
		});
		
		this.connector.addMouseDownHandler(new MouseDownHandler() {
			
			@Override
			public void onMouseDown(MouseDownEvent event) {
				
				event.stopPropagation();
				
			}
		});
		
		
		//this.connector.add
		// allows to add some way point
		this.connector.addDoubleClickHandler(new DoubleClickHandler() {
			
			@Override
			public void onDoubleClick(DoubleClickEvent event) {
				//select actual connector
				HashMap<String,ISelectable> selectedElements = new HashMap<String,ISelectable>();
				selectedElements.put(connector.getId(), connector);
				connector.getUIPanel().setSelectedElements(selectedElements);
				
				Point p = new Point(mouseX+connector.getUIPanel().getScrollLeft()+Window.getScrollLeft()-connector.getUIPanel().getAbsoluteLeft(), mouseY+connector.getUIPanel().getScrollTop()+Window.getScrollTop()-connector.getUIPanel().getAbsoluteTop());
				Point p2 = new Point(mouseX,mouseY);
				ClosestPoints closestPoints = getClosestPoints(p2);
				
				
				
				connector.fireEvent(new AddWayPointEvent(p, closestPoints
						.getMinPoint(), closestPoints.getMaxPoint()));
				
			}
		});
		
		

//		this.connector.addClickHandler(new ClickHandler() {
//
//			@Override
//			public void onClick(ClickEvent event) {
//				
//
//
//			}
//		});

	}

	public ClosestPoints getClosestPoints(Point point) {

		IConnectorPoint minPoint = this.connector.getConnectorStartPoint();

		IConnectorPoint currentPoint = minPoint;

		while (currentPoint.getNextPoint() != null) {

			Point previousPoint = new Point(currentPoint.getAbsoluteLeft(),currentPoint.getAbsoluteTop());
			Point nextPoint		= new Point(currentPoint.getNextPoint().getAbsoluteLeft(),currentPoint.getNextPoint().getAbsoluteTop());
			
			Region			r	= new Region(previousPoint,nextPoint);
			
			if (r.contains(point)){
				
				minPoint = currentPoint;
				
				break;
			}
			
			currentPoint = currentPoint.getNextPoint();

		}

		IConnectorPoint maxPoint = minPoint.getNextPoint();

		ClosestPoints closesPoints = new ClosestPoints(minPoint, maxPoint);

		return closesPoints;
	}

	@Override
	public IConnector getConnector() {
		return connector;
	}

	public class ClosestPoints {

		private IConnectorPoint minPoint;
		private IConnectorPoint maxPoint;

		public ClosestPoints(IConnectorPoint minPoint, IConnectorPoint maxPoint) {

			this.minPoint = minPoint;
			this.maxPoint = maxPoint;

		}

		public IConnectorPoint getMinPoint() {
			return minPoint;
		}

		public IConnectorPoint getMaxPoint() {
			return maxPoint;
		}

	}

}
