/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.file;

import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FolderSelectedEvent;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;
import com.gwtext.client.widgets.tree.event.TreePanelListenerAdapter;

public class FolderPanel extends com.ebmwebsourcing.geasytools.widgets.ext.impl.file.FolderPanel{

	private TreePanel treePanel;
	private TreeNode rootNode;
	
	public FolderPanel() {
		
		this.treePanel = new TreePanel();
		this.treePanel.setRootVisible(false);
		
		this.treePanel.addListener(new TreePanelListenerAdapter(){
			
			@Override
			public void onClick(TreeNode node, EventObject e) {
			
				IFolder f = (IFolder) node.getAttributeAsObject("folder");
				
				fireEvent(new FolderSelectedEvent(f));
				
			}
			
			
		});
		
		
		this.rootNode = new TreeNode();
		treePanel.setRootNode(rootNode);
		treePanel.setUseArrows(true);
		
		initWidget(treePanel);
	}
	
	@Override
	public void setFolders(List<IFolder> folders) {

		for(IFolder folder:folders){
			
			TreeNode actualFolderNode = new TreeNode(folder.getName());
			actualFolderNode.setAttribute("folder", folder);
			
			if (folder.getChildren().size()>0) buildTreeNode(folder, actualFolderNode);
			
			rootNode.appendChild(actualFolderNode);
			
		}
		treePanel.doLayout();
		super.setFolders(folders);
	}

	private void buildTreeNode(IFolder folder,TreeNode parentNode){
		
		
		for(IFolder f:folder.getChildren()){
			
			TreeNode node = new TreeNode(f.getName());
			node.setAttribute("folder", f);
			
			parentNode.appendChild(node);
			
			if (f.getChildren().size()>0) buildTreeNode(f, node);
		
		}
		
	}
	
	
	public void clearSelection(){
		treePanel.getSelectionModel().clearSelections();
	}
	
	
	@Override
	public void setHeight(int height) {
		this.treePanel.setHeight(height);
	}

	@Override
	public void setWidth(int width) {
		this.treePanel.setWidth(width);
	}
	
	
	
}
