/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.wizard;



import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.button.ToolbarButton;
import com.ebmwebsourcing.geasytools.widgets.core.api.button.IButton;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IWizard;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.AbstractWizard;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.LoadEvent;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.BoxComponent;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Container;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.event.ContainerListener;
import com.gwtext.client.widgets.event.PanelListenerAdapter;


public class Wizard extends AbstractWizard implements IWizard{
	
	private Panel mainPanel;
	private Toolbar toolbar;
	
	
	private ToolbarButton next;
	private ToolbarButton back;
	private ToolbarButton cancel;
	private ToolbarButton finish;
	
	
	public Wizard() {
		super();
		
		this.mainPanel 	= new  Panel();
		this.toolbar 	= new Toolbar();
		
		this.toolbar.addFill();
		
		this.toolbar.addButton((ToolbarButton) getBackBtn());
		this.toolbar.addButton((ToolbarButton) getNextBtn());
		this.toolbar.addButton((ToolbarButton) getCancelBtn());
		this.toolbar.addButton((ToolbarButton) getFinishBtn());
		

		this.mainPanel.setBottomToolbar(toolbar);
		this.mainPanel.setVisible(false);
		
		initWidget(mainPanel);
		
	}
	
	public Wizard(int width,int height){
		this();
		
		this.setWidth(width);
		this.setHeight(height);
		
	}
	
	@Override
	protected void onLoad() {		
		mainPanel.setVisible(true);
	}
	
	
	@Override
	public void setFrames(List<IFrame> frames) {
		super.setFrames(frames);
		
		for(IFrame f:frames){
			mainPanel.add((Widget) f);
		}
		
		mainPanel.doLayout();
	}
	
	




	@Override
	public IButton getBackBtn() {
		
		if (back==null){
			back = new ToolbarButton("Back");
		}
		
		return back;
	}

	@Override
	public IButton getCancelBtn() {
		
		if (cancel==null){
			cancel = new ToolbarButton("Cancel");
		}
		
		return cancel;
	}

	@Override
	public IButton getFinishBtn() {
		
		if (finish==null){
			finish = new ToolbarButton("Finish");	
		}
		
		return finish;
	}

	@Override
	public IButton getNextBtn() {
		
		if (next==null){
			next = new ToolbarButton("Next");	
		}
		
		return next;
	}

	@Override
	public void setHeight(int height) {
		this.mainPanel.setHeight(height);
	}

	@Override
	public void setWidth(int width) {
		this.mainPanel.setWidth(width);
	}

	@Override
	public void initialize() {
		super.initialize();
		for(IFrame f: getFrames()){
			
			WizardFrame wf = (WizardFrame) f;
			wf.doLayout();
		}
		mainPanel.doLayout();
	}

}
