/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file;

import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFilePanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFilePanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FilesSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FilesLoadedEvent;
import com.google.gwt.user.client.ui.Composite;

public abstract class FilePanel extends Composite implements IFilePanel{
	
	private List<IFile> files;
	
	public FilePanel() {
		
	}

	@Override
	public void addHandler(IFilePanelHandler handler) {
		this.addHandler(handler, FilesLoadedEvent.TYPE);
		this.addHandler(handler, FilesSelectedEvent.TYPE);		
	}
	

	
	@Override
	public void setFiles(List<IFile> files) {
		this.files = files;
		this.fireEvent(new FilesLoadedEvent());
	}

	@Override
	public List<IFile> getFiles() {
		return files;
	}
	
	
	
	
}
