/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.treepanel;

import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreeNode;
import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreePanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.event.ITreePanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.treepanel.event.NodeSelectedEvent;
import com.google.gwt.user.client.ui.Composite;

public abstract class AbstractTreePanel extends Composite implements ITreePanel{
	
	private ITreeNode rootNode;
	
	public AbstractTreePanel() {

	}
	
	@Override
	public void addHandler(ITreePanelHandler handler) {
		this.addHandler(handler, NodeSelectedEvent.TYPE);
	}

	@Override
	public void setRootNode(final ITreeNode node) {
		this.rootNode = node;
	}

	@Override
	public ITreeNode getRootNode() {
		return rootNode;
	}


}
