/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.notification;

import com.ebmwebsourcing.geasytools.widgets.ext.api.notification.INotificationBubble;
import com.ebmwebsourcing.geasytools.widgets.ext.api.notification.INotificationBubbleConfiguration;
import com.ebmwebsourcing.geasytools.widgets.ext.api.notification.event.INotificationBubbleHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.notification.event.NotificationBubbleCloseEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.notification.event.NotificationBubbleLoadEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class NotificationBubble extends Composite implements INotificationBubble{
	
	private Grid mainGrid;
	private VerticalPanel bubbleLayout;
	
	private int width;
	private int height;
	
	private int sideHeight;
	private int sideWidth;
	
	private String title;
	
	private INotificationBubbleConfiguration configuration;
	
	private HorizontalPanel contentLayout;
	private VerticalPanel messageLayout;
	
	private Label titleLbl;
	private Image messageTypeImg;
	private Label messageLbl;
	private String message;
	
	
	private HandlerManager handlerManager;
	
	private AbsolutePanel bubbleIndicator;
	
	public NotificationBubble() {
		
		this.handlerManager = new HandlerManager(this);
		
		this.bubbleLayout = new VerticalPanel();
		
		this.mainGrid = new Grid(3,3);
		
		this.bubbleLayout.add(mainGrid);
		
		this.configuration 	= new NotificationBubbleConfiguration();
		
		this.contentLayout 	= new HorizontalPanel();
		
		this.messageTypeImg 	= new Image();
		this.messageTypeImg.setStyleName("message-type");
		
		this.titleLbl 		= new Label();
		this.titleLbl.setStyleName("title");
		
		this.messageLbl 	= new Label();
		this.messageLbl.setStyleName("message");
		
		this.messageLayout = new VerticalPanel();
		this.messageLayout.setStyleName("messagelayout");
		this.messageLayout.add(titleLbl);
		this.messageLayout.add(messageLbl);
		
		this.contentLayout.add(messageTypeImg);
		this.contentLayout.add(messageLayout);
		
		
		this.bubbleIndicator = new AbsolutePanel();
		this.bubbleIndicator.setPixelSize(configuration.getIndicatorWidth(), configuration.getIndicatorHeight());
		
		this.bubbleIndicator.setStyleName("indicator");
		
		this.bubbleLayout.add(bubbleIndicator);
		
		//ADD STYLE NAME
		
		//top left cell
		this.mainGrid.getCellFormatter().getElement(0, 0).addClassName("notification-topleft");

		
		//top
		this.mainGrid.getCellFormatter().getElement(0, 1).addClassName("notification-top");

		
		//top right cell
		this.mainGrid.getCellFormatter().getElement(0, 2).addClassName("notification-topright");

		
		//left
		this.mainGrid.getCellFormatter().getElement(1, 0).addClassName("notification-left");

		
		//right
		this.mainGrid.getCellFormatter().getElement(1, 2).addClassName("notification-right");

	
		//center
		this.mainGrid.getCellFormatter().getElement(1, 1).addClassName("notification-content");
		
		
		//bottom right
		this.mainGrid.getCellFormatter().getElement(2, 2).addClassName("notification-bottomright");

		
		//bottom left
		this.mainGrid.getCellFormatter().getElement(2, 0).addClassName("notification-bottomleft");

				
		//bottom
		this.mainGrid.getCellFormatter().getElement(2, 1).addClassName("notification-bottom");
		
		
		this.mainGrid.setWidget(1, 1, contentLayout);
		
		//process sides size
		if (this.width==0 && this.height==0){
			
			this.sideHeight = this.getConfiguration().getDefaultHeight() - (this.getConfiguration().getSideImagesHeight()*2);
			this.sideWidth = this.getConfiguration().getDefaultWidth() - (this.getConfiguration().getSideImagesWidth()*2);
		
		}else{
			
			this.sideHeight = this.width - (this.getConfiguration().getSideImagesHeight()*2);
			this.sideWidth = this.height - (this.getConfiguration().getSideImagesWidth()*2);			
			
		}

		this.processCellsSize();
		
		initWidget(bubbleLayout);
		
		this.setStyleName("notification-bubble");
	}
	
	
	
	
	private void processCellsSize(){

		////SET CELLS SIZE
		
		
		//top left cell
		this.mainGrid.getCellFormatter().setWidth(0, 0, this.getConfiguration().getSideImagesWidth()+"px");
		this.mainGrid.getCellFormatter().setHeight(0, 0, this.getConfiguration().getSideImagesHeight()+"px");
		
		//top
		this.mainGrid.getCellFormatter().setWidth(0, 1, this.sideWidth+"px");
		this.mainGrid.getCellFormatter().setHeight(0, 1, this.getConfiguration().getSideImagesHeight()+"px");
		
		//top right cell
		this.mainGrid.getCellFormatter().setWidth(0, 2, this.getConfiguration().getSideImagesWidth()+"px");
		this.mainGrid.getCellFormatter().setHeight(0, 2, this.getConfiguration().getSideImagesHeight()+"px");
		
		//left
		this.mainGrid.getCellFormatter().setWidth(1, 0, this.getConfiguration().getSideImagesWidth()+"px");
		this.mainGrid.getCellFormatter().setHeight(1, 0, this.sideHeight+"px");
		
		//right
		this.mainGrid.getCellFormatter().setWidth(1, 2, this.getConfiguration().getSideImagesWidth()+"px");
		this.mainGrid.getCellFormatter().setHeight(1, 2, this.sideHeight+"px");
		
		//bottom left
		this.mainGrid.getCellFormatter().setWidth(2, 2, this.getConfiguration().getSideImagesWidth()+"px");
		this.mainGrid.getCellFormatter().setHeight(2, 2, this.getConfiguration().getSideImagesHeight()+"px");
		
		//bottom right
		this.mainGrid.getCellFormatter().setWidth(2, 0, this.getConfiguration().getSideImagesWidth()+"px");
		this.mainGrid.getCellFormatter().setHeight(2, 0, this.getConfiguration().getSideImagesHeight()+"px");
		
		
		//bottom
		this.mainGrid.getCellFormatter().setWidth(2, 1, this.sideWidth+"px");
		this.mainGrid.getCellFormatter().setHeight(2, 1, this.getConfiguration().getSideImagesHeight()+"px");
	
		
		
	}
	
	
	@Override
	public void addWidget(Widget widget) {
		this.messageLayout.add(widget);
	}

	@Override
	public INotificationBubbleConfiguration getConfiguration() {
		return configuration;
	}
	
	public void setConfiguration(INotificationBubbleConfiguration configuration){
		this.configuration = configuration;
	}

	@Override
	public int getHeight() {
		return height;
	}

	@Override
	public String getTitle() {
		return title;
	}
	
	public void setTitle(String title){
		this.title = title;
		this.titleLbl.setText(title);
	}
	
	public void setTitleVisible(boolean visible){
		this.titleLbl.setVisible(visible);
	}
	
	public void setMessageVisible(boolean visible){
		this.messageLbl.setVisible(visible);
	}
	
	public void setNoticeIconVisible(boolean visible){
		this.messageTypeImg.setVisible(visible);
	}
	
	public void setMessageType(MessageType messageType){
		
		if (messageType==MessageType.ERROR){
			
			this.messageTypeImg.setUrl(GWT.getModuleBaseURL()+"/widgets/images/notification/error.png");
			
		}else if (messageType==MessageType.INFO){
			//TODO:find correct image
			this.messageTypeImg.setUrl(GWT.getModuleBaseURL()+"/widgets/images/notification/error.png");
			
		}else if (messageType==MessageType.WARNING){
			
			this.messageTypeImg.setUrl(GWT.getModuleBaseURL()+"/widgets/images/notification/warning.png");
			
		}else if (messageType==MessageType.OK){
			
			this.messageTypeImg.setUrl(GWT.getModuleBaseURL()+"widgets/images/notification/ok.png");
			
		}
		
	}
	
	public void setMessage(String message){
		this.messageLbl.setText(message);
		this.message = message;
	}
	
	@Override
	public int getWidth() {
		return width;
	}
	
	@Override
	protected void onLoad() {
		super.onLoad();
		this.fireEvent(new NotificationBubbleLoadEvent());

	}
	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public void hide() {
		this.setVisible(false);
	}

	@Override
	public void setIndicatorVisible(boolean b) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void show() {
		this.setVisible(true);
	}




	@Override
	public void addHandler(INotificationBubbleHandler handler) {
		handlerManager.addHandler(NotificationBubbleLoadEvent.TYPE, handler);
		handlerManager.addHandler(NotificationBubbleCloseEvent.TYPE, handler);
	}

}
