/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HistoryManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ModelManagerFactory;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyModel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;

public class ModelHistoryManagerITTestGwt
extends GWTTestCase {
    private ModelManagerFactory<DummyModel> modelManagerFactory;

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.modelManagerFactory = new ModelManagerFactory();
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelHistoryIntegrationModule";
    }

    public void testUndo() {
        System.out.println("---------- TESTING UNDO ----------");
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        HistoryManager historyManager = this.modelManagerFactory.getHistoryManager();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state2");
        System.out.println("state 2==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state2", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 2==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
    }

    public void testRedo() {
        System.out.println("---------- TESTING REDO ----------");
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        HistoryManager historyManager = this.modelManagerFactory.getHistoryManager();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
        historyManager.redo((Object)model);
        System.out.println("redo state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state1", (String)model.getString1());
    }

    public void testHasMoreUndo() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        HistoryManager historyManager = this.modelManagerFactory.getHistoryManager();
        model.setString1("state1");
        boolean hasMoreUndo1 = historyManager.hasMoreUndo((Object)model);
        ModelHistoryManagerITTestGwt.assertEquals((boolean)true, (boolean)hasMoreUndo1);
        HistoryManager.getInstance().undo((Object)model);
        boolean hasMoreUndo2 = historyManager.hasMoreUndo((Object)model);
        ModelHistoryManagerITTestGwt.assertEquals((boolean)false, (boolean)hasMoreUndo2);
        try {
            historyManager.undo((Object)model);
        }
        catch (Exception e) {
            boolean isIllegalStateException = e instanceof IllegalStateException;
            ModelHistoryManagerITTestGwt.assertEquals((boolean)true, (boolean)isIllegalStateException);
        }
    }

    public void testHasMoreRedo() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        HistoryManager historyManager = this.modelManagerFactory.getHistoryManager();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state0", (String)model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((boolean)true, (boolean)historyManager.hasMoreRedo((Object)model));
        historyManager.redo((Object)model);
        System.out.println("redo state 1==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state1", (String)model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((boolean)false, (boolean)historyManager.hasMoreRedo((Object)model));
        model.setString1("state2");
        System.out.println("state 2==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((boolean)false, (boolean)historyManager.hasMoreRedo((Object)model));
        historyManager.undo((Object)model);
        System.out.println("undo state 2==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.redo((Object)model);
        System.out.println("redo state 2==>" + model.getString1());
        ModelHistoryManagerITTestGwt.assertEquals((String)"state2", (String)model.getString1());
        try {
            historyManager.redo((Object)model);
        }
        catch (Exception e) {
            boolean isIllegalStateException = e instanceof IllegalStateException;
            ModelHistoryManagerITTestGwt.assertEquals((boolean)true, (boolean)isIllegalStateException);
        }
    }
}

