/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client;



/**
 * Marker interface to enable historization on a model
 * 
 * @author nfleury
 *
 */
public interface HasModelManager {
	
	/**
	 * Clones are used to store the state of actual object at a specific moment.
	 * All fields of current object have to be copied to the new clone.Otherwise that 
	 * may lead to some inconsistencies in actual object history.<br><br>
	 * <b>Important:</b> Do not use GWT.create() while instantiating the new clone, use <b>new</b>
	 * keyword.<br>
	 * <b>Ex:</b> MyTypeToClone clone = new MyTypeToclone();<br>
	 * <b>Rather than:</b> MyTypeToClone clone = GWT.create(MyTypeToclone.class);
	 * <br><br>
	 * 
	 * <b>Important:</b> While cloning a list, only the list itself has to be a new instance,
	 *  meaning the content of the list should'nt have to be cloned<br>
	 * 
	 * <br><br> 
	 * 
	 * @return {@link HasModelManager} that is a clone of actual object.
	 */
	HasModelManager getClone();
	
	/**
	 * Copying a model means change the state of the actual one but setters 
	 * shouldn't be used while copying fields. Otherwise that may lead to some
	 * inconsistencies in actual object history.
	 * Use fields directly to copy the passed object : <br><br>
	 * 
	 * <b>Ex:</b> this.myField = objectToCopy.getMyField() <br>
	 * <b>Rather than:</b> this.setMyField(objectToCopy.getMyField()); 
	 * 
	 * <br>
	 * <br>
	 * <b>Important:</b> While copying a list from the passed object
	 * the actual model list must be replaced by a new list:
	 * <br><b>Ex:</b>this.dummyModels 	= new ArrayList<DummyModel>();
	 * 
	 * <br>
	 * <br>
	 * <b>Important:</b> While copying a field that have a mutable type,
	 * the concerned type have to be copied to. 
	 * <br><b>Ex:</b>if (mtocopy.getDummyModel()!=null) this.dummyModel.copy(mtocopy.getDummyModel());
	 *  
	 * @param object The object to copy
	 */
	void copy(Object object);
	

}
