/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HistoryManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.MethodObserver;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ModelRegistry;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ObservableManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.Utils;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HistoryManager.ICopyHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;

@SuppressWarnings("unchecked")
public abstract class AbstractUITemplate {

	private HashSet<Class<?>> mappedModelTypes;
	protected HashMap<String, List<Field>> fields;
	
	public static HashSet<UIFieldWidget> hasObserver =  new HashSet<UIFieldWidget>();

	private List<Field> classFields;
	
	
	public void setFields(HashMap<String, List<Field>> fields) {
		this.fields = fields;
	
		//set the mapped type we are dealing with actually
		final HashSet<Class<?>> modelSet = new HashSet<Class<?>>();
		
		for(List<Field> lf:fields.values()){
			
			for(Field f:lf){
				modelSet.add(ModelRegistry.getInstance().getModelProxyRealType(f.getEnclosingObject()));
			}
		}
		
		this.mappedModelTypes = modelSet;
	}

	

	protected UIFieldWidget getUIField(final String fieldName) {

		this.classFields = fields.get(fieldName);

		if (classFields == null) {
			return null;
		}

		//Get a modelproxy set from current fields
		final HashSet<ModelProxy> modelSet = new HashSet<ModelProxy>();
		for(Field f:classFields){
			
			modelSet.add((ModelProxy) f.getEnclosingObject());
			
		}
		
		//Get the number of types involved
		int typeNb = UIBindingManager.getInstance().getEnclosingObjectsTypes(modelSet).size();
		
		
		//if there is only 1 enclosing type involved and 1 field
		if (typeNb==1 && classFields.size()==1){
		
					final Field field 				= classFields.get(0);
					final UIFieldWidget uiField 	= UIBindingManager.getInstance().getWidget(fieldName, field.getType(),(ModelProxy) modelSet.toArray()[0]);
					
					
					// when ui value changes => update model value
					//only if we haven't add a handler yet
					if (hasObserver.contains(uiField)==false){
						uiField.addValueChangeHandler(new ValueChangeHandler() {
							@Override
							public void onValueChange(ValueChangeEvent event) {
								 //Window.alert("just changed model from"+field.getValue()+" to value:"+event.getValue());
								field.setValue(event.getValue());
	
							}
						});
						hasObserver.add(uiField);
					}
					// when model value changes => update ui value
					//only if we haven't add an observer yet

						ObservableManager.getInstance().addMethodObserverIfNoObserverExists(
								field.getEnclosingObject(),
								Utils.getSetterMethodByFieldName(field.getName()),
								new MethodObserver<Object>() {
	
									@Override
									public void afterMethodCalled(Object model,
											Object... parameters) {
										//Window.alert("You just changed a model value");
										Object fieldValue = ObservableManager.getInstance()
												.getFieldByName(model,
														field.getName()).getValue();
		
										uiField.setValue(fieldValue,false);
	
									}
	
									@Override
									public void beforeMethodCalled(Object model,
											Object... parameters) {
	
									}
	
								});
					

					// when a copy is made => update ui value
					HistoryManager.getInstance().addCopyHandler((ModelProxy) field.getEnclosingObject(), new ICopyHandler(){

						@Override
						public void onCopy(ModelProxy modelProxy) {
							
							Object fieldValue = ObservableManager.getInstance()
							.getFieldByName(modelProxy,
									field.getName()).getValue();
							
							uiField.setValue(fieldValue,false);
							
							
						}
						
					});
					
			// =>set initial ui widget
			// value
		
			uiField.setValue(field.getValue(),false);
			
			//call onDisplay
			uiField.onDisplay();
			return uiField;
		
		}else if (typeNb>=1 && classFields.size()>1){

				//If we have multiple model types  and multiple fields
				//All fields should have the same type here
				
				final UIFieldWidget uiField = UIBindingManager.getInstance().getWidget(fieldName,classFields.get(0).getType() ,modelSet);
				
				final ArrayList<ModelProxy> modelList = new ArrayList<ModelProxy>();
				
				for(ModelProxy m:modelSet){
					
					modelList.add(m);
					
				}
				//Add all events handlers here 
				
				//=>set initial ui widget value
				//if all fields values are equals we put one of the value into the field
				//otherwise we put the stuff to null as we cannot put multiple value into a single field
				

				
				// when ui value changes => update models value
				uiField.addValueChangeHandler(new ValueChangeHandler() {
					@Override
					public void onValueChange(ValueChangeEvent event) {
						
						List<Field> fields = (List<Field>) UIBindingManager.getInstance().getCommonFieldsFromModels(modelList).get(fieldName);
						
						for(Field f:fields){
							if (f.getName().equals(fieldName)) f.setValue(event.getValue());							
						}

					}
				});
				
				//Add listeners on models to change ui
				

				
				for(ModelProxy m:modelSet){
					
					//when models changes => update ui value
					//if every fields values are equals
					ObservableManager.getInstance().addMethodObserver(
							m,
							Utils.getSetterMethodByFieldName(fieldName),
							new MethodObserver<Object>() {
		
								@Override
								public void afterMethodCalled(Object model,
										Object... parameters) {
									

											List<Field> fields = (List<Field>) UIBindingManager.getInstance().getCommonFieldsFromModels(modelList).get(fieldName);
											
											Object fieldValue = getCommonFieldsValue(fields);
											uiField.setValue(fieldValue,false);											
						

								}
		
								@Override
								public void beforeMethodCalled(Object model,
										Object... parameters) {
		
								}
		
							});
					
					
					
					//when a copy is made => update ui value
					//if every fields values are equals
					HistoryManager.getInstance().addCopyHandler(m, new ICopyHandler(){

						@Override
						public void onCopy(ModelProxy modelProxy) {
							
							List<Field> fields = (List<Field>) UIBindingManager.getInstance().getCommonFieldsFromModels(modelList).get(fieldName);
							
							Object fieldValue = getCommonFieldsValue(fields);
							uiField.setValue(fieldValue,false);	
							
						}
						
					});
					
					
					final Object fieldValue = this.getCommonFieldsValue(classFields);
					
					uiField.setValue(fieldValue, false);
				}
				
				
			//call onDisplay
			uiField.onDisplay();
				
			return uiField;
		}

		
		return null;
	}

	/**
	 * If all fields are equals return the common value
	 * Otherwise null is returned
	 * @param fields
	 * @return
	 */
	private Object getCommonFieldsValue(List<Field> fields){
		
		Object value = fields.get(0).getValue();
		
		for(Field f : fields){
			if (f.getValue()==null && value==null) continue;
			if (f.getValue()==null && value !=null){
				return null;
			}
			if (f.getValue().equals(value)==false){
				return null;
			}
			
		}
		return value;
	}


	protected HashSet<Class<?>> getMappedModelTypes() {
		return mappedModelTypes;
	}

	public abstract Widget getTemplate();

	
	public abstract void refresh();
	

	
	
}
