/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield;

import java.util.List;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class ListUIField<T> extends AbstractUIFieldWidget<T> {
	
	private ListBox listBox;
	private List<T> values;

	
	private T value;
	
	/**
	 * 
	 * @param options List of object that should have redefined toString
	 */
	public ListUIField(final List<T> options) {
		
		
		
		this.listBox = new ListBox();
		
		load(options);
		
		this.listBox.addChangeHandler(new ChangeHandler() {
			
			@Override
			public void onChange(ChangeEvent event) {
				
				
				setValue(values.get(listBox.getSelectedIndex()), true);
				
				
			}
		});
		
		
		initWidget(listBox);
		
	}
	
	private void load(final List<T> options){
		
		this.values = options;
		
		this.listBox.clear();
		
		if (options!=null) populateListItem();
		
		if (value!=null) setValue(value, false);
		
		//if we have only one element in the list => setValue
		if (options!=null && value==null){
			if (options.size()>=1) setValue(options.get(0), true);			
		}

			
	}
	
	
	public void setOptions(List<T> options){
		load(options);
	}
	
	@Override
	protected Widget getMainWidget() {
		return listBox;
	}
	
	public void populateListItem(){
		
		for(int i=0;i<values.size();i++){
			
			this.listBox.addItem(values.get(i).toString());
			
		}
		
	}
	
	public void addItem(String item,String value){
		this.listBox.addItem(item, value);
	}

	@Override
	public T getValue() {
		
		return this.value;
	}

	@Override
	public void setValue(T value, boolean fireEvent) {
		
		if (value!=null && values!=null){
			
			for(int i=0;i<values.size();i++){
				
				if (values.get(i).equals(value)){
					
					listBox.setSelectedIndex(i);
					listBox.setItemSelected(i, true);
					break;
					
				}
							
			}
		}
		
		this.value = value;
		
		if (fireEvent) ValueChangeEvent.fire(ListUIField.this, getValue());
	}




	
	@Override
	protected boolean autoloadWidget() {
		return false;
	}
	
}
