/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HistoryManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.MethodObserver;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ModelRegistry;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ObservableManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.Utils;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HistoryManager.ICopyHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.SetterHandler;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;


/**
 * Generates a proxy for the model passed in GWT.create();
 * 
 * TODO: This class is to complicated to read => clean up that mess !
 * 
 * @author nfleury
 *
 */
public class ModelProxyGenerator extends Generator {
	
	private String CLASS_NAME_SUFFIX = "_ModelProxy";
	
	private boolean createdCopyMethod = false;
	
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
	
		
		TypeOracle oracle = context.getTypeOracle();
		
		try{
			
			JClassType type = oracle.getType(typeName);
			
			String packageName 	= type.getPackage().getName();
			String simpleName 	= type.getSimpleSourceName() + CLASS_NAME_SUFFIX;
			
			ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(packageName,simpleName);
			
			composer.addImport(ObservableManager.class.toString().replace("class", ""));
			composer.addImport(HistoryManager.class.toString().replace("class", ""));
			composer.addImport(ModelRegistry.class.toString().replace("class", ""));
			composer.addImport(MethodObserver.class.toString().replace("interface", ""));
			composer.addImport(Field.class.toString().replace("class", ""));
			composer.addImport(SetterHandler.class.toString().replace("interface", ""));
			composer.addImport(ICopyHandler.class.toString().replace("interface", "").replace("$", "."));
			
			composer.addImport(HashMap.class.toString().replace("class", ""));
			composer.addImport(Utils.class.toString().replace("class", ""));
			composer.addImport(List.class.toString().replace("interface", ""));
			
			JClassType collection = oracle.getType("java.util.Collection");
			addFieldImports(composer, type, collection);
			
			composer.setSuperclass(type.getQualifiedSourceName());
			composer.addImplementedInterface(ModelProxy.class.toString().replace("interface", ""));
			
			
			PrintWriter printWriter = context.tryCreate(logger, composer.getCreatedPackage(), composer.getCreatedClassShortName());
			if(printWriter==null){
				return composer.getCreatedClassName();
			}
			
			SourceWriter writer = composer.createSourceWriter(context,printWriter);
			
			writer.indent();
			
			
			//add constructor in which we add current
			//suscriber to historymanager
			writer.println("public "+type.getSimpleSourceName() + CLASS_NAME_SUFFIX+"(){" +
					
			"ModelRegistry.getInstance().addProxyMappedType(this.getClass(),"+type.getSimpleSourceName()+".class);\n"+
					
			"HistoryManager.getInstance().addUndoRedoSuscriber(this);\n");
			
			writer.println("this.historize();");
			
			writer.println("}");

			JClassType superType = type;
			
	while(superType!=null){
				

			for(JMethod m: superType.getMethods()){
				
				
				if (m.getName().equals("copy") && createdCopyMethod==false){

					writer.println("@Override");
					writer.println(m.toString() + "{");
					writer.println("super."+m.getName()+"(object);");
					writer.println("List<ICopyHandler> ch = HistoryManager.getInstance().getCopyHandlers(this);");
					
					writer.println("if (ch!=null) for(ICopyHandler c:ch){" +
							"c.onCopy(this);" +
							"}");
					
					//writer.println("this.historize();");
					
					writer.println("}");
					createdCopyMethod = true;
				}
				
				
				
				/**
				 * Fire observers and historization on 
				 * every setter,adder and remover
				 */
				if (isSetter(m) || isAdder(m) || isRemover(m)){
					StringBuilder parameters = new StringBuilder();
					int i = 0;
					for(JParameter p:m.getParameters()){
						parameters.append(p.getName());
						i++;
						if (m.getParameters().length>i){
							parameters.append(",");
						}
					}
					
						writer.println("@Override");
						writer.println(m.toString() + "{");
						

						
						writer.println("List<MethodObserver> observersS = ObservableManager.getInstance().getMethodObservers(this,\""+m.getName()+"\");");
						writer.println("List<MethodObserver> observersG = ObservableManager.getInstance().getMethodObservers(this);");
						
						writer.println("if (observersS!=null) for(MethodObserver o:observersS){" +
								"o.beforeMethodCalled(this,"+parameters.toString()+");"+
						"}");
						writer.println("if (observersG!=null) for(MethodObserver o:observersG){" +
								"o.beforeMethodCalled(this,"+parameters.toString()+");"+
						"}");		
		
						if (m.getReturnType().getParameterizedQualifiedSourceName().equals("void")==false){
							//writer.print("return ");
							writer.print(m.getReturnType().getSimpleSourceName()+" result = ");
						}
//						writer.println("System.out.println(\"[ before historization]=>\\n\"+this);");						

						writer.println("super."+m.getName()+"("+parameters.toString()+");");
						writer.println("this.historize();");
						//writer.println("System.out.println(\"[ after historization]=>\\n\"+this);");
						
						//if (m.getReturnType().getParameterizedQualifiedSourceName().equals("void")!=false){
										
						writer.println("if (observersS!=null) for(MethodObserver o:observersS){" +
								"o.afterMethodCalled(this,"+parameters.toString()+");"+
							"}");
						writer.println("if (observersG!=null) for(MethodObserver o:observersG){" +
								"o.afterMethodCalled(this,"+parameters.toString()+");"+
							"}");
						//}
							
						if(m.getReturnType().getParameterizedQualifiedSourceName().equals("void")==false){
							writer.println("return result;");
						}
						
						writer.println("}");
			
				}	
				
			}
		
		superType = superType.getSuperclass();
			
	}
//			//UNDO METHOD
//			writer.println("@Override");
//			writer.println("public void copy(Object previousModel){");
//			
//			generateCopyModelMethods(writer, type, type.getSimpleSourceName(), "previousModel");
//			
//			writer.println("}");
//			
//			writer.println("@Override");
//			writer.println("public void copy(Object previousModel,List<String> methods){");
//			generatePartialCopyModelMethods(writer, type, type.getSimpleSourceName(), "previousModel", "methods");
//			writer.println("}");
			
			
			//Historize METHOD
			writer.println("@Override");
			writer.println("public void historize(){");
			
			generateCloneMethods(writer, type);
			
			writer.println("}");
			
			
			//Detach method
			writer.println("@Override");
			writer.println("public Object detach(){");
			
			generateDetachMethods(writer, type);
			
			writer.println("}");			
			
			//getFields() Method
			writer.println("@Override");
			writer.println("public HashMap<String,Field> getFields(){");
				
				writer.println("HashMap<String,Field> fields = new HashMap<String,Field>();");
				
				JClassType superType2 = type;
				
				int i = 0;

				while(superType2!=null && superType2.getSimpleSourceName().equals("Object")==false){
					
					for(JField field:superType2.getFields()){
						
						writer.println("Field f"+i+" = new Field(\""+field.getName()+"\","+field.getType().getQualifiedSourceName()+".class,"+field.getEnclosingType().getQualifiedSourceName()+".class);");
							
							//as boolean may be a specific case
							if (getTypeNameAsObject(field.getType()).equals("Boolean")){
								writer.println("f"+i+".setFieldValue("+Utils.getGetterMethodByFieldName(field.getName(),true)+"());");
							}else{
								writer.println("f"+i+".setFieldValue("+Utils.getGetterMethodByFieldName(field.getName(),false)+"());");
							}
						
						
						writer.println("f"+i+".setEnclosingObject(this);");
						//set the setter handler for this field
						writer.println("f"+i+".setSetterHandler(new SetterHandler(){" +
						
						"public void setValue(Object value){"+
						
						Utils.getSetterMethodByFieldName(field.getName())+"(("+getTypeNameAsObject(field.getType())+")value);  }});");
						
						
						writer.println("fields.put(\""+field.getName()+"\",f"+i+");");
						i++;
					
					}
					superType2 = superType2.getSuperclass();
					i++;
				}
				
			writer.println("return fields;");	
			writer.println("}");			
			/////end getFields()
			
			
			writer.outdent();
			writer.commit(logger);
			
			return composer.getCreatedClassName();
			
		}catch (Exception e) {
			logger.log(TreeLogger.ERROR, "Could not generate code for:"+ typeName,e);
			
			throw new UnableToCompleteException();
		}
		
		
		
		
	}
	
	
	private void generateCloneMethods(SourceWriter writer,JClassType classType){
		
//		//create a new instance of the object
//		writer.println(classType.getSimpleSourceName()+" clone = new "+classType.getSimpleSourceName()+"();");
//		
//		JClassType superType = classType;
//		
//		while(superType!=null){
//			//get each setter of the class
//			for(JMethod m:superType.getMethods()){
//				
//				if (isSetter(m)){
//				
//					writer.println("clone."+m.getName()+"(this."+Utils.getOppositeMethodName(m.getName())+"());");
//				
//				}
//			}
//			superType = superType.getSuperclass();
//		}
		
		writer.println("HistoryManager.getInstance().addModelToHistory(this,this.getClone());");
		
	}
	
	
	
	private void generateDetachMethods(SourceWriter writer, JClassType classType){
		
		//create a new instance of the object
		writer.println(classType.getSimpleSourceName()+" clone = ("+classType.getSimpleSourceName()+") this.getClone();");
		
//		JClassType superType = classType;
//		
//		while(superType!=null){
//			//get each setter of the class
//			for(JMethod m:superType.getMethods()){
//				
//				if (isSetter(m)){
//				
//					writer.println("clone."+m.getName()+"(this."+Utils.getOppositeMethodName(m.getName())+"());");
//				
//				}
//			}
//			superType = superType.getSuperclass();
//		}
		
		writer.println("return clone;");
		
	}
	
	
	
//	private void generateCopyModelMethods(SourceWriter writer,JClassType classType,String className,String varName){
//	
//		JClassType superType = classType;
//		
//		int i = 0;
//		while(superType!=null){
//			
//			//get each setter of the class
//			for(JMethod m:superType.getMethods()){
//				
//				if (isSetter(m)){
//					
//					writer.println("List<MethodObserver> observers"+i+" = ObservableManager.getInstance().getMethodObservers(this,\""+m.getName()+"\");");
//					
//					writer.println("super."+m.getName()+"((("+className+")"+varName+")."+Utils.getOppositeMethodName(m.getName())+"());");
//					
//					if (m.getReturnType().getParameterizedQualifiedSourceName().equals("void")!=false){
//						
//						writer.println("if (observers"+i+"!=null) for(MethodObserver o:observers"+i+"){" +
//								"o.afterMethodCalled(this);"+
//							"}");
//					
//					}
//					
//					
//					
//				}
//				i++;
//			}
//	  
//			superType = superType.getSuperclass();
//		}
//	
//	}
//
//
//	
//	private void generatePartialCopyModelMethods(SourceWriter writer,JClassType classType,String className,
//			String varName, String varName2){
//		
//		JClassType superType = classType;
//		
//		int i = 0;
//		while(superType!=null){
//			
//			//get each setter of the class
//			for(JMethod m:superType.getMethods()){
//				
//				if (isSetter(m)){
//					
//					writer.println("if("+varName2+".contains(\""+m.getName()+"\")){");
//					
//					writer.println("List<MethodObserver> observers"+i+" = ObservableManager.getInstance().getMethodObservers(this,\""+m.getName()+"\");");
//					
//					writer.println("super."+m.getName()+"((("+className+")"+varName+")."+Utils.getOppositeMethodName(m.getName())+"());");
//					
//					if (m.getReturnType().getParameterizedQualifiedSourceName().equals("void")!=false){
//						
//						writer.println("if (observers"+i+"!=null) for(MethodObserver o:observers"+i+"){" +
//								"o.afterMethodCalled(this);"+
//							"}");
//					
//					}
//					
//					writer.println("}");
//					
//					i++;
//				}
//			}
//	  
//			superType = superType.getSuperclass();
//		}
//	
//	}

	
	private boolean isSetter(JMethod method){
		return method.getName().startsWith("set") && method.getParameters().length==1; 
	}
	
	private boolean isAdder(JMethod method){
		return method.getName().startsWith("add") && method.getParameters().length==1; 
	}
	
	private boolean isRemover(JMethod method){
		return method.getName().startsWith("remove") && method.getParameters().length==1;
	}
	
	
	private void addFieldImports(ClassSourceFileComposerFactory composer, JClassType type, JClassType collection){
		JClassType superType2 = type;
		while(superType2!=null && superType2.getSimpleSourceName().equals("Object")==false){
			
			for(JField field:superType2.getFields()){
				
				JType fieldType = field.getType();
				
				if(fieldType.isPrimitive()==null && !((JClassType)fieldType).isAssignableTo(collection)){
					composer.addImport(fieldType.getQualifiedSourceName());
				}
			}
			
			superType2 = superType2.getSuperclass();
		}
	}
	
	
	private String getTypeNameAsObject(JType type){
		JPrimitiveType pt = type.isPrimitive();
		if(pt==null){
			return type.getQualifiedSourceName();
		}
		else{
			if(pt.equals(JPrimitiveType.BOOLEAN)){
				return "Boolean";
			}
			else if(pt.equals(JPrimitiveType.INT)){
				return "Integer";
			}
			else if(pt.equals(JPrimitiveType.FLOAT)){
				return "Float";
			}
			else if(pt.equals(JPrimitiveType.DOUBLE)){
				return "Double";
			}
			else if(pt.equals(JPrimitiveType.CHAR)){
				return "Character";
			}
			else if(pt.equals(JPrimitiveType.SHORT)){
				return "Short";
			}
			else if(pt.equals(JPrimitiveType.LONG)){
				return "Long";
			}
			else if(pt.equals(JPrimitiveType.BYTE)){
				return "Byte";
			}
			//TODO perhaps do the other primitive types
		}
		return null;
	}
}
