/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IWidgetProvider;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * 
 * @author nfleury
 *
 */
public class DefaultTemplate extends AbstractTemplate {

	private VerticalPanel vp;
	private DefaultTemplateHandler handler;
	
	public DefaultTemplate() {
		
		this.vp = new VerticalPanel();
		initWidget(vp);
	}


	@Override
	public void onBind(IWidgetProvider widgetProvider) {
			
	Label lbl = new Label();
		
		lbl.getElement().setAttribute("style", "font-weight:bold;font-size:14px;");
		lbl.setText(getTitle());
		vp.add(lbl);
		
		ArrayList<LabelWidgetPair> allLabelWidgetPair 	= new ArrayList<LabelWidgetPair>();


		allLabelWidgetPair.addAll(getPairs(widgetProvider));

		
		Grid grid = new Grid(allLabelWidgetPair.size(),2);
		
		for(int i=0;i<=allLabelWidgetPair.size()-1;i++){
			
			LabelWidgetPair lwp = allLabelWidgetPair.get(i);
			
				grid.setWidget(i, 0, new Label(lwp.getLabel()));
				grid.setWidget(i, 1, lwp.getWidget());
			
		}
		
		vp.add(grid);

	}
	
	private List<Field> getOrderedFields(HashMap<String,Field> fields,List<String> orderedFieldsNames){
		
		ArrayList<Field> result = new ArrayList<Field>();
		
		for(int i=0;i<orderedFieldsNames.size();i++){
			
			result.add(i, fields.get(orderedFieldsNames.get(i)));
			
		}
		
		return result;
	}
	
	private List<LabelWidgetPair> getPairs(IWidgetProvider wProvider){
		
		IHasReflectionProxy mp = (IHasReflectionProxy) this.editorModel;
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		List<String> orderedFieldsName = wProvider.getOrderedFieldsName();
		List<Field>  orderedFields = getOrderedFields(mp.getFields(), orderedFieldsName);
		
		for(int i=0;i<orderedFieldsName.size();i++){
			
			Field f = orderedFields.get(i);
			
			Widget widget = (Widget) wProvider.getUIField(f.getName()); 	
			
				if (handler==null){
					
					if (widget!=null) result.add(new LabelWidgetPair( wProvider.getLabel(f.getName()), widget));
				
				}else{
					
					if (handler.load(f.getName())){
					
						if (widget!=null) result.add(new LabelWidgetPair( wProvider.getLabel(f.getName()), widget));
					
					}
					
				}
			
			
		}
		
		
		return result;
	}
	
	public void setHandler(DefaultTemplateHandler handler) {
		this.handler = handler;
	}
	
	
	protected void prepend(Widget widget){
		vp.insert(widget, 1);
	}
	
	protected void append(Widget widget){
		vp.insert(widget, vp.getWidgetCount());
	}
	
	protected class LabelWidgetPair{
		
		private String label;
		private Widget widget;
		
		public LabelWidgetPair(String label,Widget widget) {
			this.label = label;
			this.widget = widget;
		}
		
		public String getLabel() {
			return label;
		}
		
		public Widget getWidget() {
			return widget;
		}
	}


}
