/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.Utils;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Body;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ForDeclaration;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;

public class ResolverGenerator extends Generator{
	
	private ComposerHelper composerHelper;
	private Scope scope;
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		

		try {
			
			JClassType type 	= context.getTypeOracle().getType(typeName);
		
			ScopeBuilder sb 	= new ScopeBuilder(type);
			this.scope 			= sb.getScope();
			this.composerHelper = new ComposerHelper(context, logger, type.getPackage().getName(), type.getSimpleSourceName()+"_Generated");
			this.composerHelper.setSuperClass(typeName);
			
			addResolveMethod();
			
			this.composerHelper.commit();
			
		} catch (NotFoundException e) {
			
			e.printStackTrace();
		
		} catch (ScopeBuilderException e) {

			e.printStackTrace();
		}
		
		
		
		return composerHelper.getCreatedClassName();
	}

	private void addResolveMethod(){
		
		Method resolveMethod = new Method(Visibility.PUBLIC, scope.getModel(), "resolve");
		resolveMethod.isOverride(true);

		resolveMethod.getBody().append(scope.getModel().getCanonicalName()+" model = "+"new "+scope.getModel().getCanonicalName()+"()");
		
		for(Node node: scope.getRootNode().getChildren()){
			
			fillModel(resolveMethod.getBody(), "model", node,false);
			
		}
		
		resolveMethod.getBody().append("\n\n");
		
		for(Node node: scope.getRootNode().getChildren()){
			
			if (node.isCollection()){
				addNodeResolver(resolveMethod, node);
			}
			
		}
		
		resolveMethod.getBody().append("return model");
		
		composerHelper.addMethod(resolveMethod);
		
	}
	
	private void fillModel(Body body,String modelName,Node node,boolean withChildren){
		
		String getInstanceDeclaration = "this.getInstance("+node.getType().getCanonicalName()+".class)";
		
		String getInstancesDeclaration = "this.getInstances("+node.getType().getCanonicalName()+".class)";
		
		if (withChildren==true){
			getInstancesDeclaration = "this.getInstanceChildren("+modelName+","+node.getType().getCanonicalName()+".class)";
		}
		
		if (node.isCollection()==false){
			
			String content = modelName+"."+Utils.getSetterMethodByFieldName(node.getName())+"("+getInstanceDeclaration+")";
			
			body.append(content);
			
		}else{
			
			String content = modelName+"."+Utils.getGetterMethodByFieldName(node.getName(), false)+"().addAll("+getInstancesDeclaration+")";
			
			body.append(content);
			
		}
		
	}
	
	private void addNodeResolver(Method resolveMethod,Node node) {
		
		ForDeclaration forDeclaration = new ForDeclaration(node.getType(), node.getName(), "this.getInstances("+node.getType().getCanonicalName()+".class)");
		
		for(Node n:node.getChildren()){
			
			fillModel(forDeclaration.getBody(), node.getName(), n,true);
			
		}
		
		resolveMethod.getBody().append(forDeclaration.toString());
		
	}
	
}
