/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IWatchedModelProxy;

public class ScopeRegistry {
	
	//flat map => children of IHasScope are also added here
	private HashMap<String,LinkedHashSet<IHasScope>> modelsBySope;
	
	
	
	
	private static ScopeRegistry instance;
	
	private ScopeRegistry() {
		
		this.modelsBySope = new HashMap<String, LinkedHashSet<IHasScope>>();
		
	}
	
	
	public static ScopeRegistry getInstance() {
		
		if (instance==null){
			instance = new ScopeRegistry();
		}
		
		return instance;
	}
	
	
	public void registerModel(String scopeId,IHasScope model){
		
		LinkedHashSet<IHasScope> result = modelsBySope.get(scopeId);
		
		if (result==null){
			result = new LinkedHashSet<IHasScope>();
		}
		
		result.add(model);
		
		modelsBySope.put(scopeId, result);

	}
	
	
	public void clear(){
		modelsBySope.clear();
	}
	
	public LinkedHashSet<IHasScope> getModelsByScope(String scopeId){
		return modelsBySope.get(scopeId);
	}
	
	public LinkedHashSet<IHasScope> getInstancesByScope(Class<? extends IHasScope> type,String scopeId){
		
		LinkedHashSet<IHasScope> result = new LinkedHashSet<IHasScope>();
		
		LinkedHashSet<IHasScope> candidates = getModelsByScope(scopeId);
		
		if (candidates==null) return result;
		
		Iterator<IHasScope> candidateIt = candidates.iterator();
		
		while(candidateIt.hasNext()){
			
			IHasScope e = candidateIt.next();
			
			if (e instanceof IHasScopeProxy){
				
				IHasScopeProxy proxy = (IHasScopeProxy) e;
				
				if (type==proxy.getRealType()){
					
					result.add(e);
					
				}
				
			}
			
		}
		
		return result;
	}
	
	public void unregisterModel(String scopeId,IHasScope model){
		modelsBySope.get(scopeId).remove(model);
		//TODO: remove all its children
	}
	
	public <E> LinkedHashSet<E> getBindedModelInstances(Class<? extends E> type,String scopeId){
		
		LinkedHashSet<E> result = new LinkedHashSet<E>();
		
		LinkedHashSet<IHasScope> candidates = getModelsByScope(scopeId);
		
		Iterator<IHasScope> candidateIt = candidates.iterator();
		
		while(candidateIt.hasNext()){
			
			IHasScope e = candidateIt.next();
			
			//check if model is watched
			if (e instanceof IWatchedModelProxy<?>){
				
				IWatchedModelProxy<?> hasModelBinder = (IWatchedModelProxy<?>) e;
				
				Object bindedModel 					 = hasModelBinder.getBindedModel();
				
				if (bindedModel.getClass()==type){
					
					result.add((E) bindedModel);
					
				}
				

			}
			
		
		}
		
		
		return result;
	}
	

	
}
