/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import java.util.Set;

import com.google.gwt.dev.util.collect.HashSet;

public class Clazz {

	private String name;
	private Set<Method> methods;
	private boolean isInterface;
	private Visibility visibility;
	private Set<String> superClasses;
	private Set<Annotation> annotations;
	
	public Clazz(Visibility visibility,String name,boolean isInterface) {
		this.name 			= name;
		this.isInterface 	= isInterface;
		this.visibility 	= visibility;
		this.superClasses 	= new HashSet<String>();
		this.methods		= new HashSet<Method>();
		this.annotations	= new HashSet<Annotation>();
	}
	
	public String getName() {
		return name;
	}
	
	private String getSuperClasses(){
		if (superClasses.size()==0) return "";
		return superClasses.toString().replace("[", "").replace("]", "");
	}
	
	public void addSuperClass(Class<?> clazz){
		this.superClasses.add(clazz.getCanonicalName());
	}
	
	public void addAnnotation(Annotation annotation){
		this.annotations.add(annotation);
	}
	
	@Override
	public String toString() {
		
		StringBuilder sb = new StringBuilder();
		
		
		for(Annotation annotation:annotations){
			
			sb.append(annotation.toString()+"\n");
			
		}
		
		sb.append(this.visibility);
		
		if (isInterface){
			sb.append(" interface");
		}else{
			sb.append(" class");
		}
		
		sb.append(" "+name);
		
		if (superClasses.size()>0){
			sb.append(" extends "+getSuperClasses());
		}
		
		sb.append("{\n\n");
		
		for(Method m : methods){
			if (isInterface) m.setHasBody(false);
			sb.append(m.toString()+"\n");
		}
		
		sb.append("\n\n}");
		
		return sb.toString();
	}
	
	
	
}
