/**
 * webeditor-api - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.api.core;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.toolbar.IToolbarComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IConfirmDialogCallBack;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.ILayout;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IExportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IOpenProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.upload.IUploadWindow;

public interface IEditorView {

	ILayout getDefaultLayout();
	
	void close();
	
	void setLayout(ILayout layout);
	
	ILayout getLayout();
	
	IMainMenuComponent getMainMenuComponent();
	
	IToolbarComponent getToolbarComponent();
	
	IOpenProjectConfigurationView getOpenProjectConfigurationView();
	
	IImportProjectConfigurationView getImportProjectConfigurationView();
	
	IExportProjectConfigurationView getExportProjectConfigurationView();
	
	IEditProjectConfigurationView getEditProjectConfigurationView();
	
	IUploadWindow getUploadWindow();
	
	void enableLoadingState(String message);
	
	void disableLoadingState();
	
	void displayError(String title,String message,IEditorErrorLevel level);
	
	void displayConfirmDialog(String title,String message,IConfirmDialogCallBack dialogCallback);
}
