/**
 * webeditor-dao - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.xstream;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.IProjectDao;
import com.ebmwebsourcing.webeditor.api.IProjectTypeDao;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;

public class ProjectDao extends AbstractDao<IProjectInstance> implements IProjectDao{
	
	private IProjectTypeDao projectTypeDao;
	
	public ProjectDao() {
		this.projectTypeDao = new ProjectTypeDao();
	}
	
	@Override
	public List<IProjectInstance> getAllUserProjects(IUser user) {
		return this.getSpace();
	}

	@Override
	public IProjectTypeDao getProjectTypeDao() {
		return projectTypeDao;
	}


	@Override
	public List<IProjectInstance> getUserProjectsByType(IUser user,
			IProjectType projectType) {

		ArrayList<IProjectInstance> instances = new ArrayList<IProjectInstance>();
		
		for(IProjectInstance pi : getSpace()){
			
			if (pi.getAuthor().equals(user)&&pi.getProjectType().equals(projectType)){
				
				instances.add(pi);
				
			}
			
		}
		
		
		return instances;
	}

	@Override
	public void saveProjectInstance(IProjectInstance projectInstance) {
		
		save(projectInstance);
		
		projectTypeDao.saveProjectType(projectInstance.getProjectType());
	}

	@Override
	protected String getSpaceName() {
		return "projects";
	}

	@Override
	public IProjectInstance getProjectById(String id) {
		
		for(IProjectInstance pi:getSpace()){
			if (pi.getId().equals(id)){
				return pi;
			}
		}
		
		return null;
	}

	@Override
	protected void update(IProjectInstance object) {
		
		for(IProjectInstance pi : space){
			
			if (pi.getId().equals(object.getId())){
				
				space.remove(pi);
				space.add(object);
			}
			
		}
		
	}



}
