/**
 * webeditor-domain - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.domain.user;

import com.ebmwebsourcing.webeditor.api.domain.user.IUser;

public class User implements IUser{
	
	private String login;
	private String mail;
	private String id;
	private String password;
	
	@Override
	public String getLogin() {
		return login;
	}

	@Override
	public String getMail() {
		return mail;
	}

	@Override
	public void setLogin(String login) {
		this.login = login;
	}

	@Override
	public void setMail(String mail) {
		this.mail = mail;
	}

	@Override
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	@Override
	public boolean equals(Object obj) {
		return ((User)obj).getId().equals(this.getId());
	}
	
	@Override
	public int hashCode() {
		return this.getId().hashCode();
	}

	@Override
	public String getPassword() {
		return password;
	}

	@Override
	public void setPassword(String pwd) {
		this.password = pwd;
	}
	
}
