/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core;

import java.util.HashSet;

import net.customware.gwt.presenter.client.place.PlaceManager;

import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IComponentDispatcher;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorRegistry;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorView;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IComponentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IContentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.ICoreManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IDownloadManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IMainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IPluginManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IPresenterManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IProjectManager;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IToolbarManager;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.ILayoutHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.service.IServiceFactory;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorLoadEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.ComponentManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.ContentManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.CoreManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.DownloadManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.MainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.PluginManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.PresenterManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.ProjectManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager.ToolbarManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.service.ServiceFactory;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Timer;

public class EditorController implements IEditorFrontController{
	
	private IEditorView view;
	private IEditorRegistry registry;

	private HandlerManager handlerManager;

	private IServiceFactory serviceFactory;

	private IEditorEventBus eventBus;
	
	private IComponentDispatcher componentDispatcher;
	
	//MANAGERS
	private ICoreManager coreManager;
	private IMainMenuManager mainMenuManager;
	private IComponentManager componentManager;
	private IPluginManager pluginManager;
	private IProjectManager projectManager;
	private IContentManager contentManager;
	private IPresenterManager presenterManager;
	private IDownloadManager downloadManager;
	private IToolbarManager toolbarManager;

	
	
	public EditorController(IEditorView designerView, HashSet<IPlugin> plugins) {
		
		this.view 					= designerView;
		this.registry 				= new EditorRegistry(this);
		this.handlerManager			= new HandlerManager(this);
		
		this.eventBus				= new EditorEventBus();
		
		this.serviceFactory			= new ServiceFactory();

		//Managers
		this.coreManager			= new CoreManager(this);
		this.mainMenuManager		= new MainMenuManager(this);
		this.componentManager		= new ComponentManager(this);
		this.pluginManager			= new PluginManager(this);
		this.projectManager		 	= new ProjectManager(this);
		this.contentManager			= new ContentManager(this);
		this.presenterManager		= new PresenterManager(this);
		this.downloadManager		= new DownloadManager();
		this.toolbarManager			= new ToolbarManager(this);
		
		this.componentDispatcher	= new ComponentDispatcher(this);
		

		this.fireEvent(new EditorLoadEvent());

		///TODO: shouldnt be done like that. There should be an handler
		//that is registered before another one or a stuff like that ... find it
		Timer t =new Timer() {
			
			@Override
			public void run() {

				PlaceManager pm = new PlaceManager(eventBus);
				pm.fireCurrentPlace();
			}
		};
		
		t.schedule(500);
		
		this.registry.registerPlugins(plugins);
	}
	
	
//	public EditorController(IEditorView view,HashSet<IPlugin> plugins) {
//		this(view);
//		this.registry.registerPlugins(plugins);
//	}
	
	
	@Override
	public void addComponentHandler(IComponentHandler handler) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addLayoutHandler(ILayoutHandler handler) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public IEditorRegistry getRegistry() {
		return registry;
	}

	@Override
	public IEditorView getView() {
		return view;
	}

	@Override
	public void fireEvent(GwtEvent<?> event) {
		handlerManager.fireEvent(event);
	}


	@Override
	public void addEditorHandler(IEditorHandler handler) {
		handlerManager.addHandler(EditorLoadEvent.TYPE, handler);
	}


	@Override
	public IEditorEventBus getEventBus() {
		return eventBus;
	}

	@Override
	public IComponentManager getComponentManager() {
		return componentManager;
	}

	@Override
	public IMainMenuManager getMainMenuManager() {
		return mainMenuManager;
	}

	@Override
	public IPluginManager getPluginManager() {
		return pluginManager;
	}

	@Override
	public IProjectManager getProjectManager() {
		return projectManager;
	}

	@Override
	public IDownloadManager getDownloadManager() {
		return downloadManager;
	}


	@Override
	public IServiceFactory getServiceFactory() {
		return serviceFactory;
	}



	@Override
	public IComponentDispatcher getComponentDispatcher() {
		return componentDispatcher;
	}


	@Override
	public IPresenterManager getPresenterManager() {
		return presenterManager;
	}


	@Override
	public IToolbarManager getToolbarManager() {
		return toolbarManager;
	}


	@Override
	public IContentManager getContentManager() {
		return contentManager;
	}


	@Override
	public ICoreManager getCoreManager() {
		return coreManager;
	}

}
