/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events;

import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IConfirmDialogCallBack;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IConfirmDialogEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorHandler;
import com.google.gwt.event.shared.GwtEvent;

public class ConfirmDialogEvent extends GwtEvent<IEditorHandler> implements IConfirmDialogEvent{
	
	private String message;
	private String title;
	private IConfirmDialogCallBack callBack;
	
	public static Type<IEditorHandler> TYPE = new Type<IEditorHandler>();
	
	public ConfirmDialogEvent(String title,String message,IConfirmDialogCallBack callback) {
		
		this.message = message;
		this.title = title;
		this.callBack = callback;
		
	}
	
	@Override
	protected void dispatch(IEditorHandler handler) {
		handler.onConfirmDialog(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IEditorHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IConfirmDialogCallBack getConfirmationCallback() {
		return callBack;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public String getTitle() {
		return title;
	}

}
