/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events;

import net.customware.gwt.presenter.client.DefaultEventBus;
import net.customware.gwt.presenter.client.place.PlaceChangedEvent;
import net.customware.gwt.presenter.client.place.PlaceChangedHandler;

import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.events.IPluginManagerHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ISystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IUserContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.events.IProjectHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.PanelChangeEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.plugin.events.PluginRegisteredEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.plugin.events.PluginRegistrationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.EditProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ExportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ImportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.NewProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.OpenProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.ContentUpdateEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.CopyEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.DeleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.PasteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.SelectAllEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.SelectContentElementsEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.events.ProjectValidationRequestEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;

public class EditorEventBus extends DefaultEventBus implements IEditorEventBus{

	@Override
	public void addComponentHandler() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addLayoutHandler() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addMenuComponentHandler() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addPluginHandler() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addPluginManagerHandler(IPluginManagerHandler handler) {
		
		addHandler(PluginRegisteredEvent.TYPE, handler);
		addHandler(PluginRegistrationCompleteEvent.TYPE, handler);
	}

	@Override
	public void addProjectConfigurationHandler(
			IProjectConfigurationHandler handler) {

		addHandler(OpenProjectConfigurationCompleteEvent.TYPE, handler);
		addHandler(ImportProjectConfigurationCompleteEvent.TYPE, handler);
		addHandler(ExportProjectConfigurationCompleteEvent.TYPE, handler);
		addHandler(NewProjectConfigurationCompleteEvent.TYPE, handler);
		addHandler(EditProjectConfigurationCompleteEvent.TYPE, handler);
	}


	

	
	
	@Override
	public void addProjectHandler(IProjectHandler handler) {
		addHandler(ProjectValidationRequestEvent.TYPE, handler);
	}

	@Override
	public void addEditorHandler(IEditorHandler handler) {
		addHandler(EditorLoadEvent.TYPE, handler);
		addHandler(EditorErrorEvent.TYPE, handler);
		addHandler(EnableLoadingStateEvent.TYPE, handler);
		addHandler(DisableLoadingStateEvent.TYPE, handler);
		addHandler(ConfirmDialogEvent.TYPE, handler);
	}

	@Override
	public void addContentPanelPlaceHolderHandler(
			IContentPanelPlaceHolderHandler handler) {
		
		addHandler(PanelChangeEvent.TYPE, handler);
		
	}

	@Override
	public void addRequestHandler(IRequestHandler handler) {
		addHandler(RequestEvent.TYPE, handler);
	}

	@Override
	public void addPlaceChangeHandler(PlaceChangedHandler handler) {
		addHandler(PlaceChangedEvent.getType(), handler);
	}

	@Override
	public void addSystemContentHandler(ISystemContentHandler handler) {
		addHandler(SelectContentElementsEvent.Type, handler);
		addHandler(ContentUpdateEvent.TYPE, handler);
	}

	@Override
	public void addUserContentHandler(IUserContentHandler handler) {
		addHandler(CopyEvent.TYPE, handler);
		addHandler(PasteEvent.TYPE, handler);
		addHandler(DeleteEvent.TYPE, handler);
		addHandler(SelectAllEvent.TYPE, handler);
	}
	
}
