/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.content.IDefaultRequestContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IContentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IContentUpdateEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ISelectContentElementsEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ISystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.content.DefaultRequestContentHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceContentElement;

public class ContentManager extends AbstractManager implements IContentManager{
	

	private IDefaultRequestContentHandler defaultRequestContentHandler;
	
	private List<IProjectInstanceContentElement> contentElements;
	
	private List<IContentPanelComponent> unSavedComponents;
	
	public ContentManager(IEditorFrontController controller) {
		super(controller);
		
		this.unSavedComponents = new ArrayList<IContentPanelComponent>();
		
	}



	@Override
	public void bindEvents() {

		handleContentElementsSelected();
		handleContentUpdate();
		handleRequest();
		
	}

	@Override
	public List<IProjectInstanceContentElement> getContentElements() {
		return contentElements;
	}

	@Override
	public void handleContentElementsSelected() {
			
		getEventBus().addSystemContentHandler(new ISystemContentHandler() {
			
			@Override
			public void onSelectContentElements(ISelectContentElementsEvent event) {
				
				contentElements = event.getContentElements();
				
			}

			@Override
			public void onContentUpdate(IContentUpdateEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
	}

	@Override
	public IDefaultRequestContentHandler getDefaultRequestContentHandler() {
		
		if (defaultRequestContentHandler==null){
			this.defaultRequestContentHandler = new DefaultRequestContentHandler(this);
		}
		
		return defaultRequestContentHandler;
	}

	@Override
	public void handleRequest() {
		
		getEventBus().addRequestHandler(getDefaultRequestContentHandler());
		
	}



	@Override
	public void handleContentUpdate() {
		
		//When content is updated add marker to component panel
		getEventBus().addSystemContentHandler(new ISystemContentHandler() {
			
			@Override
			public void onSelectContentElements(ISelectContentElementsEvent event) {
			
				
			}
			
			@Override
			public void onContentUpdate(IContentUpdateEvent event) {
				
				IContentPanelComponent component = event.getComponent(); 
				
				markContentPanelNotSaved(component);
				
			}
		});
		
	}

	

	@Override
	public List<IContentPanelComponent> getUnSavedContentPanels() {
		return unSavedComponents;
	}



	@Override
	public void markContentPanelNotSaved(IContentPanelComponent component) {
					
		String actualTitle = component.getTitle();
		
		if (actualTitle!=null){
		if (actualTitle.startsWith("*")==false) component.setTitle("*"+actualTitle);
		}
		component.setSaved(false);
		
	}



	@Override
	public void markContentPanelSaved(IContentPanelComponent component) {

		String actualTitle = component.getTitle();
		
		if (actualTitle!=null){
		if (actualTitle.startsWith("*")==true) component.setTitle(actualTitle.replace("*",""));
		}
		
		component.setSaved(true);
		
	
	}

}
