/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.DefaultErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.mainmenu.IDefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.mainmenu.IDefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.mainmenu.IDefaultSystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IMainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.response.IGetSelectedContentElementsResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.ISaveProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IValidateActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorErrorEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.mainmenu.DefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.mainmenu.DefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.mainmenu.DefaultSystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.EditProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ExportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ImportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.OpenProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.DeleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.request.GetSelectedContentElementsRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.events.ProjectValidationRequestEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.SaveProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.ValidateActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceContentElement;
import com.ebmwebsourcing.webeditor.api.domain.project.ProjectValidationException;
import com.google.gwt.user.client.History;

public class MainMenuManager extends AbstractManager implements IMainMenuManager{

	private IDefaultPluginHandler defaultPluginHandler;
	
	private IDefaultSystemContentHandler defaultSystemContentHandler;
	
	private IDefaultContentPanelPlaceHolderHandler defaultContentPanelPlaceHolderHandler;
	
	public MainMenuManager(IEditorFrontController controller) {
		
		super(controller);

		
		
		
	}

	@Override
	public void handleNewPlugin() {
		
		getEventBus().addPluginManagerHandler(getDefaultPluginHandler());
			
			
		
		
	}

	@Override
	public void initializeMenu() {
		
		//Add default main menu to the main menu place holder
		IMainMenuComponent mainMenuComponent = getFrontController().getView().getMainMenuComponent(); 
		
		getFrontController().getView()
		.getDefaultLayout()
		.getMainMenuPlaceHolder()
		.setComponent(mainMenuComponent);
		
	
		////File Menu
		mainMenuComponent.getOpenItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				String req = OpenProjectPresenter.PLACE.getId();
				
				History.newItem(req);
			
			}
		});
		
		
		mainMenuComponent.getImportItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				String req = ImportProjectPresenter.PLACE.getId();
				
				History.newItem(req);
				
			}
		});
		
		mainMenuComponent.getExportItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				String req = ExportProjectPresenter.PLACE.getId();
				
				History.newItem(req);
				
			}
		});
		
		mainMenuComponent.getSaveItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				getEventBus().fireEvent(new RequestEvent(new SaveProjectInstanceRequest(getFrontController().getProjectManager().getActualProjectInstance()), new ISaveProjectInstanceResponseHandler() {
					
					@Override
					public void receiveResponse(IProjectFile result) {
						
				
						
					}
				}));
				
			}
		});
		
		
		/////Edit
		
		//Delete
		mainMenuComponent.getDeleteItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				getEventBus().fireEvent(new RequestEvent(new GetSelectedContentElementsRequest(), new IGetSelectedContentElementsResponseHandler() {
					
					@Override
					public void receiveResponse(List<IProjectInstanceContentElement> result) {
						
						getEventBus().fireEvent(new DeleteEvent(result));
						
					}
				}));
				
				
				
			}
		});
		
		
		////Project
		
		//Edit 
		mainMenuComponent.getEditProjectItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				getEventBus().fireEvent(new RequestEvent(new GetActualProjectInstanceRequest(), new IGetActualProjectInstanceResponseHandler(){
					@Override
					public void receiveResponse(IProjectInstance result) {
						
						String req = EditProjectPresenter.PLACE.requestWith(EditProjectPresenter.PROJECT_ID_PARAM, result.getId()).toString();
						
						History.newItem(req);
						
					}
				}));
				
			}
		});
		
		//validate
		mainMenuComponent.getValidateProjectItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				getEventBus().fireEvent(new RequestEvent(new ValidateActualProjectInstanceRequest(), new IValidateActualProjectInstanceResponseHandler() {
					
					@Override
					public void receiveResponse(ProjectValidationException result) {
						
						if (result!=null) getEventBus().fireEvent(new EditorErrorEvent("Validation Errors", "Actual project contains following error(s):<br>"+result.getMessage(), DefaultErrorLevel.ERROR));
						
					}
				}));
				
			}
		});
		
		
		//File
		mainMenuComponent.getSaveItem().setEnable(false);
		mainMenuComponent.getExportItem().setEnable(false);
		
		//Edit
		mainMenuComponent.getCopyItem().setEnable(false);
		mainMenuComponent.getPasteItem().setEnable(false);
		mainMenuComponent.getSelectAllItem().setEnable(false);
		mainMenuComponent.getDeleteItem().setEnable(false);
		
		//Project
		mainMenuComponent.getEditProjectItem().setEnable(false);
		mainMenuComponent.getValidateProjectItem().setEnable(false);
		
		//Help
		mainMenuComponent.getWelcomeItem().setEnable(false);
		
	}

	@Override
	public IDefaultPluginHandler getDefaultPluginHandler() {
		
		if (this.defaultPluginHandler == null){
			
			this.defaultPluginHandler = new DefaultPluginHandler(this); 
		
		}
		
		return defaultPluginHandler;
	}

	@Override
	public void bindEvents() {
		
		initializeMenu();
		handleNewPlugin();
		handleContent();
		handlePanelChange();
	}

	@Override
	public IDefaultSystemContentHandler getDefaultSystemContentHandler() {
		
		if (this.defaultSystemContentHandler ==null){
			
			this.defaultSystemContentHandler = new DefaultSystemContentHandler(this);
			
		}
		
		return this.defaultSystemContentHandler;
	}

	@Override
	public void handleContent() {
		
		getEventBus().addSystemContentHandler(getDefaultSystemContentHandler());
		
	}

	@Override
	public IDefaultContentPanelPlaceHolderHandler getDefaultContentPanelPlaceHolderHandler() {
		
		if (this.defaultContentPanelPlaceHolderHandler ==null){
			this.defaultContentPanelPlaceHolderHandler = new DefaultContentPanelPlaceHolderHandler(this);
		}
		
		return defaultContentPanelPlaceHolderHandler;
	}

	@Override
	public void handlePanelChange() {
		
		getEventBus().addContentPanelPlaceHolderHandler(getDefaultContentPanelPlaceHolderHandler());
		
	}

}
