/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.presenter.IDefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IPresenterManager;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.presenter.DefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.EditProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ExportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ImportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.OpenProjectPresenter;

public class PresenterManager extends AbstractManager implements IPresenterManager{
	
	private IDefaultPluginHandler defaultPluginHandler;
	
	public PresenterManager(IEditorFrontController controller) {
		super(controller);
		
	}

	@Override
	public void bindPresenters() {
		

		
		OpenProjectPresenter openProjectPresenter 		= new OpenProjectPresenter(getFrontController().getView().getOpenProjectConfigurationView(), getEventBus());
		openProjectPresenter.bind();
		
		ImportProjectPresenter importProjectPrenseter 	= new ImportProjectPresenter(getFrontController().getView().getImportProjectConfigurationView(), getEventBus());
		importProjectPrenseter.bind();
		
		ExportProjectPresenter	exportProjectPresenter 	= new ExportProjectPresenter(getFrontController().getView().getExportProjectConfigurationView(), getEventBus());
		exportProjectPresenter.bind();
		
		EditProjectPresenter editProjectPresenter 		= new EditProjectPresenter(getFrontController().getView().getEditProjectConfigurationView(), getEventBus());
		editProjectPresenter.bind();
		
//		PlaceManager pm 								= new PlaceManager(getEventBus());
//		pm.fireCurrentPlace();

	}

	@Override
	public IDefaultPluginHandler getDefaultPlugingHandler() {
		
		if (defaultPluginHandler==null){
			this.defaultPluginHandler = new DefaultPluginHandler(this);
		}
		
		return defaultPluginHandler;
	}

	@Override
	public void bindEvents() {
		getEventBus().addPluginManagerHandler(getDefaultPlugingHandler());
	}

}
