/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.layout;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IMultipleComponentPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IMultipleComponentPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.AddComponentEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.ComponentHideEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.ComponentShownEvent;

public class MultipleComponentsPlaceHolder extends PlaceHolder implements IMultipleComponentPlaceHolder{
	
	private HashSet<IComponent> components;
	
	public MultipleComponentsPlaceHolder(int maxComponents) {
		super();
		this.components = new HashSet<IComponent>();
	}

	
	@Override
	public void addComponent(IComponent component) {
		this.components.add(component);
		component.setPlaceHolder(this);
		this.fireEvent(new AddComponentEvent(component));
	}

	@Override
	public HashSet<IComponent> getComponents() {
		return components;
	}
	
	
	@Override
	public int getMaxComponents() {
		// TODO Auto-generated method stub
		return 0;
	}


	@Override
	public void displayAllComponents() {
		
		for(IComponent c : components){
			c.show();
		}
		
	}


	@Override
	public void hideAllComponents() {
		
		for(IComponent c : components){
			c.hide();
		}
		
	}


	@Override
	public void addHandler(IMultipleComponentPlaceHolderHandler handler) {
		this.handlerManager.addHandler(AddComponentEvent.TYPE, handler);
		this.handlerManager.addHandler(ComponentHideEvent.TYPE, handler);
		this.handlerManager.addHandler(ComponentShownEvent.TYPE, handler);
	}

	
}
