/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.layout;


import com.ebmwebsourcing.geasytools.webeditor.api.layout.IPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IPlaceHolderPosition;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.AddComponentEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;

public class PlaceHolder implements IPlaceHolder{
	

	private String title;
	private String name;
	private IPlaceHolderPosition position;
	protected HandlerManager handlerManager;
	
	public PlaceHolder() {
		

		
		this.handlerManager = new HandlerManager(this);
		
	}
	
	@Override
	public IPlaceHolderPosition getPosition() {
		return position;
	}
	
	@Override
	public void setPosition(IPlaceHolderPosition position) {
		this.position = position;
	}
	
	@Override
	public String getName() {
		return name;
	}
	
	
	@Override
	public void setName(String name) {
		this.name = name;
	}
	
	



	@Override
	public String getTitle() {
		return title;
	}

	@Override
	public void setTitle(String title) {
		this.title = title;
	}



	@Override
	public void setHeight(int height) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setWidth(int width) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void fireEvent(GwtEvent<?> event) {
		this.handlerManager.fireEvent(event);
	}

	@Override
	public void addHandler(IPlaceHolderHandler handler) {
		handlerManager.addHandler(AddComponentEvent.TYPE, handler);
	}

	@Override
	public void hide() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void show() {
		// TODO Auto-generated method stub
		
	}
	
}
