/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import java.util.List;

import net.customware.gwt.presenter.client.place.Place;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.widget.WidgetPresenter;

import com.ebmwebsourcing.geasytools.webeditor.api.core.DefaultErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.presenter.IExportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IExportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IValidateActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorErrorEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ExportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.ValidateActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IBackEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ICancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ILoadEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.INextEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.ProjectValidationException;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;

public class ExportProjectPresenter extends WidgetPresenter<IExportProjectConfigurationView> implements IExportProjectPresenter{
	
	private IEditorEventBus eventBus;

	
	
	private IProjectInstance actualProjectInstance;
	private IProjectInstanceFormat selectedExportFortmat;
	private List<IProjectInstanceFormat> currentExportFormats;
	
	private boolean projectIsValid;
	
	public static final Place PLACE = new Place("Export.Project");
	
	public static final String PARAM_PROJECT_EXPORT_FORMAT = "projectExportFormat";
	
	public ExportProjectPresenter(IExportProjectConfigurationView display,
			IEditorEventBus eventBus) {
		super(display, eventBus);
		
		this.eventBus = eventBus;
		
	}

	@Override
	public Place getPlace() {
		return PLACE;
	}

	@Override
	protected void onBind() {
		

		
		/////EXPORT COMBOBOX HANDLER
		getDisplay().getExportFormat().addValueChangeHandler(new ValueChangeHandler<IProjectInstanceFormat>() {
			
			@Override
			public void onValueChange(ValueChangeEvent<IProjectInstanceFormat> event) {
				
				//add export format to request
				String req = PLACE.requestWith(PARAM_PROJECT_EXPORT_FORMAT, event.getValue().toString()).toString();
				
				History.newItem(req);
				
			}
		});
		
		
		
		
		/////WIZARD HANDLER
		getDisplay().getWizard().addHandler(new IWizardHandler() {
			
			@Override
			public void onNext(INextEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onLoad(ILoadEvent event) {
				
			}
			
			@Override
			public void onFinish(IFinishEvent event) {
				
				if(selectedExportFortmat!=null){
					eventBus.fireEvent(new ExportProjectConfigurationCompleteEvent(actualProjectInstance,selectedExportFortmat));
					selectedExportFortmat = null;
					display.refresh();
					History.newItem(PLACE.request().toString());
				}
				
			}
			
			@Override
			public void onCancel(ICancelEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onBack(IBackEvent event) {
				// TODO Auto-generated method stub
				
			}
		});
		
		

	}

	@Override
	protected void onPlaceRequest(final PlaceRequest request) {
	
			//Proceed only if actual project is valid
			eventBus.fireEvent(new RequestEvent(new ValidateActualProjectInstanceRequest(), new IValidateActualProjectInstanceResponseHandler() {
				
				@Override
				public void receiveResponse(ProjectValidationException result) {

					//no error
					if (result==null){
						
						projectIsValid = true;
						
						//On revealing get actual project instance by firing request
						//as actual project instance may have changed
						eventBus.fireEvent(new RequestEvent(new GetActualProjectInstanceRequest(), new IGetActualProjectInstanceResponseHandler() {
							
							@Override
							public void receiveResponse(IProjectInstance result) {
								
								actualProjectInstance = result;
								
							}
						}));
						
						String selectedProjectExportFormat	= request.getParameter(PARAM_PROJECT_EXPORT_FORMAT, null);
						
				
						
						if (actualProjectInstance.getProjectType().getExportFormats()==null){
							throw new IllegalStateException("Actual project instance type:"+actualProjectInstance.getProjectType()+" doesn't have any associated export format");
						}
						
						currentExportFormats = actualProjectInstance.getProjectType().getExportFormats();
						
						
						if (selectedProjectExportFormat!=null){
							for(IProjectInstanceFormat f:currentExportFormats){
								if (f.toString().equals(selectedProjectExportFormat)){
									selectedExportFortmat = f;
								}
							}
							refreshDisplay(false);
						}
						else{
							refreshDisplay();
						}
						
					}else{
						
						projectIsValid = false;
						
						History.newItem("");
						
						//notify user
						eventBus.fireEvent(new EditorErrorEvent("Cannot export project", "Cannot save actual project because of the following errors:<br>"+result.getMessage(), DefaultErrorLevel.ERROR));
						
						
						
					}
					
					
				}
			}));
		

	
	
	}

	@Override
	protected void onUnbind() {
		// TODO Auto-generated method stub
		
	}
	
	private void updateExportFormats(boolean clear){
		if(clear){
			getDisplay().getExportFormat().clear();
		}

		for(IProjectInstanceFormat f:currentExportFormats){
			getDisplay().getExportFormat().addItem(f,f.toString());
		}
	}
	
	@Override
	public void refreshDisplay() {
		refreshDisplay(true);
	}
	
	public void refreshDisplay(boolean clearFormat){
		if (actualProjectInstance!=null){
			updateExportFormats(clearFormat);
			getDisplay().getActualProject().setValue(actualProjectInstance);
		}
		
		if (selectedExportFortmat!=null){
			getDisplay().getExportFormat().setValue(selectedExportFortmat);
			getDisplay().getExportFormatDescription().setValue(selectedExportFortmat.getDescription());
		}
	}

	@Override
	public void revealDisplay() {
		if (selectedExportFortmat==null && projectIsValid==true){
			display.open();
		}
	}

	@Override
	public IProjectInstance getActualProjectInstance() {
		return actualProjectInstance;
	}

	@Override
	public IProjectInstanceFormat getSelectedExportFormat() {
		return selectedExportFortmat;
	}

	@Override
	public List<IProjectInstanceFormat> getCurrentExportFormats() {
		return currentExportFormats;
	}

}
