/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.Folder;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;

public abstract class AbstractImportProjectConfigurationView extends ProjectConfigurationView implements IImportProjectConfigurationView{
	



	
	
	@Override
	public void setAvailableProjectTypes(List<IProjectType> projectTypes) {
		
		ArrayList<IFolder> folders = new ArrayList<IFolder>();
		
		for(int i=0;i<projectTypes.size();i++){
			
			IProjectType currentProjectType = projectTypes.get(i); 
			
			Folder f = new Folder(currentProjectType.getName());
			f.setAttribute("projectType", currentProjectType);
			
			folders.add(f);
			
			if (currentProjectType.getSubProjectType().size()>0) buildFolder(currentProjectType, f);
			
		}
		
		
		getFolderPanel().setFolders(folders);
	}

	private void buildFolder(IProjectType projectType,Folder parentFolder){
		
		for(int i=0;i<projectType.getSubProjectType().size();i++){
			
			IProjectType currentProjectType = projectType.getSubProjectType().get(i); 
			
			Folder f = new Folder(currentProjectType.getName());
			f.setAttribute("projectType", currentProjectType);
			
			parentFolder.addFolder(f);
			
			if (currentProjectType.getSubProjectType().size()>0) buildFolder(currentProjectType, f);
			
		}
		
	}
	



}
