/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ExportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ImportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.NewProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.OpenProjectConfigurationCompleteEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;


public abstract class ProjectConfigurationView implements IProjectConfigurationView{
	
	protected HandlerManager handlerManager;
	
	public ProjectConfigurationView() {

		
		this.handlerManager = new HandlerManager(this);
		
	

	}
	
	

	@Override
	public void fireEvent(GwtEvent<?> event) {
		handlerManager.fireEvent(event);

	}





	@Override
	public void addHandler(IProjectConfigurationHandler handler) {
		handlerManager.addHandler(NewProjectConfigurationCompleteEvent.TYPE, handler);
		handlerManager.addHandler(OpenProjectConfigurationCompleteEvent.TYPE, handler);
		handlerManager.addHandler(ImportProjectConfigurationCompleteEvent.TYPE, handler);
		handlerManager.addHandler(ExportProjectConfigurationCompleteEvent.TYPE, handler);
	}





}
