/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.request;

import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IResponseHandler;

import com.google.gwt.event.shared.GwtEvent;

public class RequestEvent extends GwtEvent<IRequestHandler> implements IRequestEvent{
	
	public static Type<IRequestHandler> TYPE = new Type<IRequestHandler>(); 
	
	private IRequest request;
	private IResponseHandler<?> responseHandler;
	
	public RequestEvent(IRequest request,IResponseHandler<?> responseHandler) {
	
		this.request 			= request;
		this.responseHandler 	= responseHandler;
		
	}
	
	
	@Override
	protected void dispatch(IRequestHandler handler) {
		handler.onRequest(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IRequestHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IRequest getRequest() {
		return request;
	}

	@Override
	public IResponseHandler<?> getResponseHandler() {
		return responseHandler;
	}

}
