/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.server.service.project;

import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import com.ebmwebsourcing.geasytools.webeditor.impl.client.service.project.IProjectService;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.server.impl.service.project.ProjectServiceImpl;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class GWTProjectServiceImpl extends RemoteServiceServlet implements IProjectService{
	
	
	private static ProjectServiceImpl projectService ;
	
	@Override
	public void init(ServletConfig config) throws ServletException {
		super.init(config);

		projectService = ProjectServiceImpl.getInstance();
	}
	/**
	 * 
	 */
	private static final long serialVersionUID = -1302386057985728789L;

	@Override
	public List<IProjectFile> getProjectFilesByProjectType(
			IProjectType projectType) throws ServiceException {
		

		return projectService.getProjectFilesByProjectType(projectType);
		
	}



	@Override
	public String exportProjectInstance(IProjectInstance instance,
			IProjectInstanceFormat format) throws ServiceException {
		
		return projectService.exportProjectInstance(instance, format);
	}

	@Override
	public List<IProjectInstance> importProjectInstance(String uploadedRef,
			IProjectType projectType, IProjectInstanceFormat format)
			throws ServiceException {
		
		//ensure httpsession is set for upload service 
		projectService.setSession(this.getThreadLocalRequest().getSession());

		return projectService.importProjectInstance(uploadedRef, projectType, format);
	}

	@Override
	public List<IProjectInstance> loadProjectInstances(
			List<IProjectFile> projectFiles) throws ServiceException {
	
		return projectService.loadProjectInstances(projectFiles);
	}

	@Override
	public IProjectFile saveProjectInstance(IProjectInstance projectInstance)
			throws ServiceException {
		
		return projectService.saveProjectInstance(projectInstance);
	}



	@Override
	public IProjectInstance getProjectInstanceById(String id)
			throws ServiceException {

		return projectService.getProjectInstanceById(id);
	}



	@Override
	public IProjectInstanceMetaData addMetaData(String uploadRef,
			IProjectInstance projectInstance,IProjectInstanceFormat metaDataFormat) throws ServiceException {
		
		//ensure httpsession is set for upload service 
		projectService.setSession(this.getThreadLocalRequest().getSession());
		
		return projectService.addMetaData(uploadRef, projectInstance,metaDataFormat);
	}
	
	

	

}
