/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu;



import com.ebmwebsourcing.geasytools.webeditor.api.components.IQualifiedName;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IMenuItemHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenu;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemAction;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemGroup;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.AddMenuItemEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.UpdateMenuItemEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;

public class MenuItem implements IMenuItem{
	
	private IQualifiedName qname;

	private HandlerManager handlerManager;
	private String label;
	private IMenuItemClickHandler clickHandler;
	private IMenuItemAction action;
	private IMenuItemGroup group;
	private boolean enable;
	
	private IMenu subMenu;
	
	public MenuItem() {

		this.handlerManager = new HandlerManager(this);
	}
	
	public MenuItem(String text){
		this();
		this.label = text;
	}
	
	@Override
	public IQualifiedName getQualifiedName() {
		return qname;
	}



	@Override
	public void setQualifiedName(IQualifiedName qname) {
		this.qname = qname;
	}



	@Override
	public void fireEvent(GwtEvent<?> event) {
		handlerManager.fireEvent(event);
	}

	

	@Override
	public void addHandler(IMenuItemHandler handler) {
		handlerManager.addHandler(com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.ClickEvent.TYPE, handler);
		handlerManager.addHandler(AddMenuItemEvent.TYPE, handler);
		handlerManager.addHandler(UpdateMenuItemEvent.TYPE, handler);
	}


	@Override
	public String getText() {
		return label;
	}



	@Override
	public void setText(String label) {
		this.label = label;
		this.fireEvent(new UpdateMenuItemEvent(this));
	}



	@Override
	public IMenuItemClickHandler getClickHandler() {
		return clickHandler;
	}



	@Override
	public void setClickHandler(IMenuItemClickHandler clickHandler) {
		this.clickHandler = clickHandler;
	}

	@Override
	public IMenu getSubMenu() {
		return subMenu;
	}

	@Override
	public void setSubMenu(IMenu menu) {
		this.subMenu = menu;
	}

	@Override
	public IMenuItemAction getAction() {
		return action;
	}

	@Override
	public IMenuItemGroup getGroup() {
		return group;
	}

	@Override
	public void setAction(IMenuItemAction action) {
		this.action = action;
	}

	@Override
	public void setGroup(IMenuItemGroup group) {
		this.group = group;
	}

	@Override
	public boolean isEnable() {
		return this.enable;
	}

	@Override
	public void setEnable(boolean b) {
		this.enable = b;
	}



}
