/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IImportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.event.shared.GwtEvent;

public class ImportProjectConfigurationCompleteEvent extends GwtEvent<IProjectConfigurationHandler> implements IImportProjectConfigurationCompleteEvent{
	
	public static Type<IProjectConfigurationHandler> TYPE = new Type<IProjectConfigurationHandler>();
	
	private IProjectInstanceFormat format;
	private IProjectType projectType;
	private String uploadRef;
	
	private IProjectConfigurationView view;
	
	public ImportProjectConfigurationCompleteEvent(String uploadRef,IProjectType projectType,IProjectInstanceFormat format,IProjectConfigurationView view) {
		
		this.format 		= format;
		this.projectType 	= projectType;
		this.uploadRef 		= uploadRef;
		this.view 			= view;
		
	}
	
	@Override
	protected void dispatch(IProjectConfigurationHandler handler) {
		handler.onConfigurationComplete(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IProjectConfigurationHandler> getAssociatedType() {
		return TYPE;
	}



	@Override
	public IProjectConfigurationView getProjectConfigurationView() {
		return view;
	}

	@Override
	public IProjectInstanceFormat getFormat() {
		return format;
	}

	@Override
	public IProjectType getProjectType() {
		return projectType;
	}

	@Override
	public String getUploadRef() {
		return uploadRef;
	}



}
