/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.service.project;

import com.ebmwebsourcing.geasytools.webeditor.api.service.IServiceAsync;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.user.client.rpc.AsyncCallback;


public interface IProjectServiceAsync extends IServiceAsync{


	void exportProjectInstance(com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance projectFile, com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat format, com.google.gwt.user.client.rpc.AsyncCallback<java.lang.String> arg3);
	void getProjectFilesByProjectType(com.ebmwebsourcing.webeditor.api.domain.project.IProjectType projectType, com.google.gwt.user.client.rpc.AsyncCallback<java.util.List<com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile>> arg2);
	void importProjectInstance(java.lang.String uploadedRef, com.ebmwebsourcing.webeditor.api.domain.project.IProjectType projectType, com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat format, com.google.gwt.user.client.rpc.AsyncCallback<java.util.List<com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance>> arg4);
	void loadProjectInstances(java.util.List<com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile> projectFiles, com.google.gwt.user.client.rpc.AsyncCallback<java.util.List<com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance>> arg2);
	void loadProjectInstanceByUrl(String url,IProjectType type,IProjectInstanceFormat format,AsyncCallback<IProjectInstance> result);
	void saveProjectInstance(com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance projectInstance, com.google.gwt.user.client.rpc.AsyncCallback<com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile> arg2);
	void getProjectInstanceById(String id,AsyncCallback<IProjectInstance> result);
	void addMetaData(String uploadRef,IProjectInstance projectInstance,IProjectInstanceFormat metaDataFormat,AsyncCallback<IProjectInstanceMetaData> result);
}
