/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.dataexporter.adapter.flow;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.flow.FlowStepAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepDTO;
import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="flowAdapter")
public class FlowAdapter {
    @Resource(name="flowStepManager")
    private FlowStepManager flowStepManager;
    private FlowStepAdapter flowStepAdapter = new FlowStepAdapter();

    public void populateDTO(FlowDTO flowDTO, Flow flow) throws FlowException {
        flowDTO.setId(flow.getId());
        flowDTO.setIdpetals(flow.getIdpetals());
        flowDTO.setType(flow.getType());
        this.populateFlowStepList(flowDTO, flow);
    }

    private void populateFlowStepList(FlowDTO flowDTO, Flow flow) throws FlowException {
        ArrayList<FlowStepDTO> flowStepDTOList = new ArrayList<FlowStepDTO>();
        List<FlowStep> flowStepList = this.flowStepManager.loadSteps(flow.getIdpetals(), flow.getType());
        for (FlowStep flowStep : flowStepList) {
            FlowStepDTO flowStepDTO = new FlowStepDTO();
            this.flowStepAdapter.populateDTO(flowStepDTO, flowStep);
            flowStepDTOList.add(flowStepDTO);
        }
        flowDTO.setFlowSteps(flowStepDTOList);
    }
}

