/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.dataexporter.exporter;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.flow.FlowAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepParameterDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.exporter.ExporterFlow;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.springframework.stereotype.Service;

@Service(value="flowExporter")
public class ExporterFlowImpl
implements ExporterFlow {
    @Resource(name="flowAdapter")
    private FlowAdapter flowAdapter;

    @Override
    public void exporReferential(List<Flow> flows) throws Exception {
        String fileName = "test.xml";
        FileOutputStream file = new FileOutputStream(fileName);
        PrintStream printer = new PrintStream(file);
        Marshaller marshaller = this.prepareMarshaller();
        printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        for (Flow flow : flows) {
            FlowDTO flowDTO = new FlowDTO();
            this.flowAdapter.populateDTO(flowDTO, flow);
            marshaller.marshal((Object)flowDTO, (OutputStream)file);
        }
    }

    private Marshaller prepareMarshaller() throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FlowDTO.class, FlowStepDTO.class, FlowStepParameterDTO.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.fragment", (Object)true);
        return marshaller;
    }
}

