/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.dataexporter.exporter;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.referential.FlowRefAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.referential.FlowStepErrorRefAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.referential.FlowStepRefAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.referential.FlowRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.referential.FlowStepErrorRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.referential.FlowStepParameterRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.referential.FlowStepRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.exporter.ExporterReferential;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.springframework.stereotype.Service;

@Service(value="dataexporter")
public class ExporterReferentialImpl
implements ExporterReferential {
    @Resource(name="flowRefManager")
    private FlowRefManager flowRefManager;
    @Resource(name="flowStepRefManager")
    private FlowStepRefManager flowStepRefManager;
    private FlowRefAdapter flowRefAdapter = new FlowRefAdapter();
    private FlowStepRefAdapter flowStepRefAdapter = new FlowStepRefAdapter();
    private FlowStepErrorRefAdapter flowStepErrorRefAdapter = new FlowStepErrorRefAdapter();

    @Override
    public void exportReferential(Writer output, String[] idFlowRef) throws Exception {
        output.write(" <dataset xmlns=\"http://petalsView.com/dataset\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://petalsView.com/dataset referential-dataset.xsd\">");
        Marshaller marshaller = this.prepareMarshaller();
        this.loadFlowRef(idFlowRef, output, marshaller);
        output.write("</dataset>");
    }

    private void loadFlowRef(String[] idFlowRef, Writer output, Marshaller marshaller) throws JAXBException, FlowRefException {
        for (String id : idFlowRef) {
            FlowRef flowRef = this.flowRefManager.loadFlowRef(id);
            FlowRefDTO flowRefDTO = new FlowRefDTO();
            this.flowRefAdapter.populateDTO(flowRefDTO, flowRef);
            marshaller.marshal((Object)flowRefDTO, output);
            this.loadStepRef(output, marshaller, flowRef);
        }
    }

    private void loadStepRef(Writer output, Marshaller marshaller, FlowRef flowRef) throws JAXBException, FlowRefException {
        List<FlowStepRef> listFlowStepRef = this.flowStepRefManager.loadSteps(flowRef.getType());
        for (FlowStepRef flowStepRef : listFlowStepRef) {
            FlowStepRefDTO flowStepRefDTO = new FlowStepRefDTO();
            this.flowStepRefAdapter.populateDTO(flowStepRefDTO, flowStepRef);
            marshaller.marshal((Object)flowStepRefDTO, output);
            this.loadStepParametersRef(output, marshaller, flowStepRef);
            this.laodStepErrorRef(flowStepRef);
        }
    }

    private void laodStepErrorRef(FlowStepRef flowStepRef) throws FlowRefException {
        List<FlowStepErrorRef> listFlowStepErrorRef = this.flowStepRefManager.loadStepRefErrors(flowStepRef.getId());
        for (FlowStepErrorRef flowStepErrorRef : listFlowStepErrorRef) {
            FlowStepErrorRefDTO flowStepErrorRefDTO = new FlowStepErrorRefDTO();
            this.flowStepErrorRefAdapter.populateDTO(flowStepErrorRefDTO, flowStepErrorRef);
        }
    }

    private void loadStepParametersRef(Writer output, Marshaller marshaller, FlowStepRef flowStepRef) throws JAXBException {
        ArrayList<FlowStepParameterRefDTO> listFlowStepParamDTO = new ArrayList<FlowStepParameterRefDTO>();
        this.flowStepRefAdapter.populateParamDTO(listFlowStepParamDTO, flowStepRef.getParameterNames(), flowStepRef.getId());
        for (FlowStepParameterRefDTO flowStepParamRefDTO : listFlowStepParamDTO) {
            marshaller.marshal((Object)flowStepParamRefDTO, output);
        }
    }

    private Marshaller prepareMarshaller() throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FlowRefDTO.class, FlowStepErrorRefDTO.class, FlowStepParameterRefDTO.class, FlowStepRefDTO.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.fragment", (Object)true);
        return marshaller;
    }
}

