/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.dataloader;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.dataloader.DataLoaderException;
import com.ebmwebsourcing.petalsview.service.dataloader.Dataloader;
import com.ebmwebsourcing.petalsview.service.dataloader.ViewDatasetHandler;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.webcommons.util.InputStreamUtil;
import com.petalsview.dataset.Dataset;
import com.petalsview.dataset.FlowRef;
import com.petalsview.dataset.FlowStepParameterRef;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="dataloader")
public class DataLoaderImpl
implements Dataloader {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Resource(name="flowRefManager")
    private FlowRefManager flowRefManager;
    @Resource(name="flowStepRefManager")
    private FlowStepRefManager flowStepRefManager;

    @Override
    public void loadDataSet(String xmlDataSetLocation) throws DataLoaderException {
        InputStream datasetStream;
        this.logger.info((Object)("Load a petals view dataset from location: " + xmlDataSetLocation));
        try {
            datasetStream = InputStreamUtil.getInputStream((String)xmlDataSetLocation);
        }
        catch (Exception e) {
            throw new DataLoaderException("Can't load Petals View dataset", e);
        }
        this.loadDataset(datasetStream);
    }

    @Override
    public void loadDataset(InputStream datasetStream) throws DataLoaderException {
        Dataset dataset = null;
        try {
            dataset = ViewDatasetHandler.getInstance().convertStreamSource2ViewDataset(new StreamSource(datasetStream));
        }
        catch (Exception e) {
            throw new DataLoaderException("Can't load Petals View dataset", e);
        }
        HashMap<String, String> flowRefIndexToFlowRefId = new HashMap<String, String>();
        this.loadFlowRef(dataset, flowRefIndexToFlowRefId);
        HashMap<String, String> flowStepRefIndexToFlowStepRefId = new HashMap<String, String>();
        this.loadFlowStepRef(dataset, flowStepRefIndexToFlowStepRefId, flowRefIndexToFlowRefId);
        this.loadFlowStepParamRef(dataset, flowStepRefIndexToFlowStepRefId);
        HashMap<String, String> flowStepErrorRefId = new HashMap<String, String>();
        this.loadFlowStepErrorRef(dataset, flowStepErrorRefId, flowStepRefIndexToFlowStepRefId);
    }

    private void loadFlowRef(Dataset dataset, Map<String, String> flowRefIndexToFlowRefId) throws DataLoaderException {
        List<FlowRef> flowR = dataset.getFlowRef();
        for (FlowRef fR : flowR) {
            try {
                String id = this.flowRefManager.createFlowRef(fR.getType(), fR.getName());
                flowRefIndexToFlowRefId.put(fR.getIndex(), id);
            }
            catch (Exception e) {
                throw new DataLoaderException("A Referential with that informations already exists in database", e);
            }
        }
    }

    private void loadFlowStepRef(Dataset dataset, Map<String, String> flowStepRefIndexToFlowStepRefId, Map<String, String> flowRefIndexToFlowRefId) throws DataLoaderException {
        List<com.petalsview.dataset.FlowStepRef> flowStepR = dataset.getFlowStepRef();
        for (com.petalsview.dataset.FlowStepRef fSR : flowStepR) {
            FlowStepRef flowStepRef = new FlowStepRef();
            flowStepRef.setDefaultErrorMessage(fSR.getDefaultErrorMessage());
            flowStepRef.setFlowEndStep(fSR.isFlowEndStep().booleanValue());
            flowStepRef.setFlowStartStep(fSR.isFlowStartStep().booleanValue());
            flowStepRef.setInterfaceName(fSR.getInterfaceName());
            flowStepRef.setServiceName(fSR.getServiceName());
            flowStepRef.setName(fSR.getName());
            flowStepRef.setSuccessMessage(fSR.getSucessMessage());
            String idStepRef = fSR.getFlowRefIndex();
            if (idStepRef != null) {
                com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef flowRef = null;
                try {
                    flowRef = this.flowRefManager.loadFlowRef(flowRefIndexToFlowRefId.get(idStepRef));
                }
                catch (Exception e) {
                    throw new DataLoaderException("A Referential with that informations already exists in database", e);
                }
                flowStepRef.setFlowref(flowRef);
            }
            try {
                String id = this.flowStepRefManager.saveOrUpdateStepRef(flowStepRef);
                flowStepRefIndexToFlowStepRefId.put(fSR.getIndex(), id);
            }
            catch (Exception e) {
                throw new DataLoaderException("A Referential with that informations already exists in database", e);
            }
        }
    }

    private void loadFlowStepParamRef(Dataset dataset, Map<String, String> flowStepRefIndexToFlowStepRefId) throws DataLoaderException {
        List<FlowStepParameterRef> flowStepParamRef = dataset.getFlowStepParameterRef();
        for (FlowStepParameterRef fSPR : flowStepParamRef) {
            String idStepRef = fSPR.getFlowStepRefIndex();
            if (idStepRef != null) {
                try {
                    this.flowStepRefManager.addParameterName(flowStepRefIndexToFlowStepRefId.get(idStepRef), fSPR.getIdx(), fSPR.getName(), fSPR.isGlobal());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new DataLoaderException("Can't load step with id : " + idStepRef, e);
                }
            }
            throw new DataLoaderException("Can't load step because its id is null");
        }
    }

    private void loadFlowStepErrorRef(Dataset dataset, Map<String, String> flowStepErrorRefId, Map<String, String> flowStepRefIndexToFlowStepRefId) throws DataLoaderException {
        List<com.petalsview.dataset.FlowStepErrorRef> flowStepError = dataset.getFlowStepErrorRef();
        for (com.petalsview.dataset.FlowStepErrorRef fSER : flowStepError) {
            String idStepRef = fSER.getFlowStepRefIndex();
            if (idStepRef == null) continue;
            try {
                FlowStepRef flowStepRef = this.flowStepRefManager.loadStepRef(flowStepRefIndexToFlowStepRefId.get(idStepRef));
                FlowStepErrorRef flowStepErrorRef = new FlowStepErrorRef();
                flowStepErrorRef.setErrorCode(fSER.getErrorCode().intValue());
                flowStepErrorRef.setFlowstepref(flowStepRef);
                flowStepErrorRef.setMessage(fSER.getMessage());
                String id = this.flowStepRefManager.saveOrUpdateErrorRef(flowStepErrorRef);
                flowStepErrorRefId.put(fSER.getIndex(), id);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DataLoaderException("Can't load step with id : " + idStepRef, e);
            }
        }
    }
}

